/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchException;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class ShardSearchFailure
extends ShardOperationFailedException {
    public static final String REASON_FIELD = "reason";
    public static final String NODE_FIELD = "node";
    public static final String INDEX_FIELD = "index";
    public static final String SHARD_FIELD = "shard";
    public static final ShardSearchFailure[] EMPTY_ARRAY = new ShardSearchFailure[0];
    private SearchShardTarget shardTarget;

    ShardSearchFailure(StreamInput in) throws IOException {
        this.shardTarget = in.readOptionalWriteable(SearchShardTarget::new);
        if (this.shardTarget != null) {
            this.index = this.shardTarget.getFullyQualifiedIndexName();
            this.shardId = this.shardTarget.getShardId().getId();
        }
        this.reason = in.readString();
        this.status = RestStatus.readFrom(in);
        this.cause = in.readException();
    }

    public ShardSearchFailure(Exception e) {
        this(e, null);
    }

    public ShardSearchFailure(Exception e, @Nullable SearchShardTarget shardTarget) {
        super(shardTarget == null ? null : shardTarget.getFullyQualifiedIndexName(), shardTarget == null ? -1 : shardTarget.getShardId().getId(), ExceptionsHelper.stackTrace(e), ExceptionsHelper.status(ExceptionsHelper.unwrapCause(e)), ExceptionsHelper.unwrapCause(e));
        Throwable actual = ExceptionsHelper.unwrapCause(e);
        if (actual instanceof SearchException) {
            this.shardTarget = ((SearchException)actual).shard();
        } else if (shardTarget != null) {
            this.shardTarget = shardTarget;
        }
    }

    @Nullable
    public SearchShardTarget shard() {
        return this.shardTarget;
    }

    @Override
    public String toString() {
        return "shard [" + String.valueOf(this.shardTarget == null ? "_na" : this.shardTarget) + "], reason [" + this.reason + "], cause [" + (this.cause == null ? "_na" : ExceptionsHelper.stackTrace(this.cause)) + "]";
    }

    public static ShardSearchFailure readShardSearchFailure(StreamInput in) throws IOException {
        return new ShardSearchFailure(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.shardTarget);
        out.writeString(this.reason);
        RestStatus.writeTo(out, this.status);
        out.writeException(this.cause);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(SHARD_FIELD, this.shardId());
        builder.field(INDEX_FIELD, this.index());
        if (this.shardTarget != null) {
            builder.field(NODE_FIELD, this.shardTarget.getNodeId());
        }
        builder.field(REASON_FIELD);
        builder.startObject();
        ElasticsearchException.generateThrowableXContent(builder, params, this.cause);
        builder.endObject();
        builder.endObject();
        return builder;
    }
}

