/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.sampling;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.ingest.SamplingService;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.AbstractTransportRequest;
import org.elasticsearch.xcontent.ToXContent;

public class GetSampleStatsAction
extends ActionType<Response> {
    public static final GetSampleStatsAction INSTANCE = new GetSampleStatsAction();
    public static final String NAME = "indices:admin/sample/stats";

    private GetSampleStatsAction() {
        super(NAME);
    }

    public static class NodeResponse
    extends BaseNodeResponse {
        private final SamplingService.SampleStats sampleStats;

        protected NodeResponse(StreamInput in) throws IOException {
            super(in);
            this.sampleStats = new SamplingService.SampleStats(in);
        }

        protected NodeResponse(DiscoveryNode node, SamplingService.SampleStats sampleStats) {
            super(node);
            this.sampleStats = sampleStats;
        }

        public SamplingService.SampleStats getSampleStats() {
            return this.sampleStats;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.sampleStats.writeTo(out);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeResponse other = (NodeResponse)o;
            return this.getNode().equals(other.getNode()) && this.sampleStats.equals(other.sampleStats);
        }

        public int hashCode() {
            return Objects.hash(this.getNode(), this.sampleStats);
        }
    }

    public static class Response
    extends BaseNodesResponse<NodeResponse>
    implements Writeable,
    ChunkedToXContent {
        final int maxSize;

        public Response(StreamInput in) throws IOException {
            super(in);
            this.maxSize = in.readInt();
        }

        public Response(ClusterName clusterName, List<NodeResponse> nodes, List<FailedNodeException> failures, int maxSize) {
            super(clusterName, nodes, failures);
            this.maxSize = maxSize;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeInt(this.maxSize);
        }

        public SamplingService.SampleStats getSampleStats() {
            SamplingService.SampleStats rawStats = this.getRawSampleStats();
            return rawStats.adjustForMaxSize(this.maxSize);
        }

        private SamplingService.SampleStats getRawSampleStats() {
            return this.getNodes().stream().map(NodeResponse::getSampleStats).filter(Objects::nonNull).reduce(SamplingService.SampleStats::combine).orElse(new SamplingService.SampleStats());
        }

        @Override
        protected List<NodeResponse> readNodesFrom(StreamInput in) throws IOException {
            return in.readCollectionAsList(NodeResponse::new);
        }

        @Override
        protected void writeNodesTo(StreamOutput out, List<NodeResponse> nodes) throws IOException {
            out.writeCollection(nodes);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response other = (Response)o;
            return Objects.equals(this.getNodes(), other.getNodes()) && this.maxSize == other.maxSize;
        }

        public int hashCode() {
            return Objects.hash(this.getNodes(), this.maxSize);
        }

        @Override
        public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
            return ChunkedToXContentHelper.chunk(this.getSampleStats());
        }
    }

    public static class NodeRequest
    extends AbstractTransportRequest
    implements IndicesRequest {
        private final String indexName;

        public NodeRequest(String indexName) {
            this.indexName = indexName;
        }

        public NodeRequest(StreamInput in) throws IOException {
            super(in);
            this.indexName = in.readString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.indexName);
        }

        public String getIndexName() {
            return this.indexName;
        }

        @Override
        public String[] indices() {
            return new String[]{this.indexName};
        }

        @Override
        public IndicesOptions indicesOptions() {
            return IndicesOptions.STRICT_SINGLE_INDEX_NO_EXPAND_FORBID_CLOSED_ALLOW_SELECTORS;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeRequest other = (NodeRequest)o;
            return Objects.equals(this.indexName, other.indexName);
        }

        public int hashCode() {
            return Objects.hash(this.indexName);
        }
    }

    public static class Request
    extends BaseNodesRequest
    implements IndicesRequest.Replaceable {
        private String indexName;

        public Request(String indexName) {
            super((String[])null);
            this.indexName = indexName;
        }

        @Override
        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, "get sample stats", parentTaskId, headers);
        }

        @Override
        public ActionRequestValidationException validate() {
            if (this.indexName.contains("*")) {
                return (ActionRequestValidationException)new ActionRequestValidationException().addValidationError("Wildcards are not supported, but found [" + this.indexName + "]");
            }
            return null;
        }

        @Override
        public IndicesRequest indices(String ... indices) {
            assert (indices.length == 1) : "GetSampleStatsAction only supports a single index name";
            this.indexName = indices[0];
            return this;
        }

        @Override
        public String[] indices() {
            return new String[]{this.indexName};
        }

        @Override
        public IndicesOptions indicesOptions() {
            return IndicesOptions.STRICT_SINGLE_INDEX_NO_EXPAND_FORBID_CLOSED_ALLOW_SELECTORS;
        }
    }
}

