/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ResolvedIndexExpression;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public record ResolvedIndexExpressions(List<ResolvedIndexExpression> expressions) implements Writeable
{
    public static final TransportVersion RESOLVED_INDEX_EXPRESSIONS = TransportVersion.fromName("resolved_index_expressions");

    public ResolvedIndexExpressions(StreamInput in) throws IOException {
        this(in.readCollectionAsImmutableList(ResolvedIndexExpression::new));
    }

    public List<String> getLocalIndicesList() {
        return this.expressions.stream().flatMap(e -> e.localExpressions().indices().stream()).toList();
    }

    public List<String> getRemoteIndicesList() {
        return this.expressions.stream().flatMap(e -> e.remoteExpressions().stream()).toList();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.expressions);
    }

    public static final class Builder {
        private final List<ResolvedIndexExpression> expressions = new ArrayList<ResolvedIndexExpression>();

        public void addExpressions(String original, HashSet<String> localExpressions, ResolvedIndexExpression.LocalIndexResolutionResult resolutionResult, Set<String> remoteExpressions) {
            Objects.requireNonNull(original);
            Objects.requireNonNull(localExpressions);
            Objects.requireNonNull(resolutionResult);
            Objects.requireNonNull(remoteExpressions);
            this.expressions.add(new ResolvedIndexExpression(original, new ResolvedIndexExpression.LocalExpressions(localExpressions, resolutionResult, null), remoteExpressions));
        }

        public void addRemoteExpressions(String original, Set<String> remoteExpressions) {
            Objects.requireNonNull(original);
            Objects.requireNonNull(remoteExpressions);
            this.expressions.add(new ResolvedIndexExpression(original, ResolvedIndexExpression.LocalExpressions.NONE, remoteExpressions));
        }

        public void excludeFromLocalExpressions(Set<String> expressionsToExclude) {
            Objects.requireNonNull(expressionsToExclude);
            if (!expressionsToExclude.isEmpty()) {
                for (ResolvedIndexExpression prior : this.expressions) {
                    Set<String> localExpressions = prior.localExpressions().indices();
                    if (localExpressions.isEmpty()) continue;
                    localExpressions.removeAll(expressionsToExclude);
                }
            }
        }

        public ResolvedIndexExpressions build() {
            return new ResolvedIndexExpressions(this.expressions);
        }
    }
}

