/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.template;

import java.util.Collections;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.template.resources.TemplateResources;

public class TemplateUtils {
    private TemplateUtils() {
    }

    public static String loadTemplate(String resource, String version, String versionProperty) {
        return TemplateUtils.loadTemplate(resource, version, versionProperty, Collections.emptyMap());
    }

    public static String loadTemplate(String resource, String version, String versionProperty, Map<String, String> variables) {
        try {
            String source = TemplateResources.load((String)resource);
            source = TemplateUtils.replaceVariables(source, version, versionProperty, variables);
            TemplateUtils.validate(source);
            return source;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to load template [" + resource + "]", e);
        }
    }

    public static void validate(String source) {
        if (source == null) {
            throw new ElasticsearchParseException("Template must not be null", new Object[0]);
        }
        if (Strings.isEmpty((CharSequence)source)) {
            throw new ElasticsearchParseException("Template must not be empty", new Object[0]);
        }
        try {
            XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, (String)source, (boolean)false);
        }
        catch (Exception e) {
            throw new ElasticsearchParseException("Invalid template", (Throwable)e, new Object[0]);
        }
    }

    public static String replaceVariables(String input, String version, String versionProperty, Map<String, String> variables) {
        String template = TemplateUtils.replaceVariable(input, versionProperty, version);
        for (Map.Entry<String, String> variable : variables.entrySet()) {
            template = TemplateUtils.replaceVariable(template, variable.getKey(), variable.getValue());
        }
        return template;
    }

    public static String replaceVariable(String input, String variable, String value) {
        return input.replace("${" + variable + "}", value);
    }

    public static boolean checkTemplateExistsAndVersionIsGTECurrentVersion(String templateName, ClusterState state, long currentVersion) {
        ComposableIndexTemplate templateMetadata = (ComposableIndexTemplate)state.metadata().getProject().templatesV2().get(templateName);
        if (templateMetadata == null) {
            return false;
        }
        return templateMetadata.version() != null && templateMetadata.version() >= currentVersion;
    }
}

