/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.topn;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DocBlock;
import org.elasticsearch.compute.data.DocVector;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.operator.topn.DocVectorEncoder;
import org.elasticsearch.compute.operator.topn.ResultBuilder;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

class ResultBuilderForDoc
implements ResultBuilder {
    private final BlockFactory blockFactory;
    private final DocVectorEncoder encoder;
    private final int[] shards;
    private final int[] segments;
    private final int[] docs;
    private int position;

    ResultBuilderForDoc(BlockFactory blockFactory, DocVectorEncoder encoder, int positions) {
        this.blockFactory = blockFactory;
        this.encoder = encoder;
        this.shards = new int[positions];
        this.segments = new int[positions];
        this.docs = new int[positions];
    }

    @Override
    public void decodeKey(BytesRef keys) {
        throw new AssertionError((Object)"_doc can't be a key");
    }

    @Override
    public void decodeValue(BytesRef values) {
        int shard;
        this.shards[this.position] = shard = this.encoder.decodeInt(values);
        this.encoder.refCounteds().get(shard).mustIncRef();
        this.segments[this.position] = this.encoder.decodeInt(values);
        this.docs[this.position] = this.encoder.decodeInt(values);
        ++this.position;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Block build() {
        DocBlock docBlock;
        block3: {
            boolean success = false;
            IntVector shardsVector = null;
            IntVector segmentsVector = null;
            try {
                shardsVector = this.blockFactory.newIntArrayVector(this.shards, this.position);
                segmentsVector = this.blockFactory.newIntArrayVector(this.segments, this.position);
                IntVector docsVector = this.blockFactory.newIntArrayVector(this.docs, this.position);
                DocBlock docsBlock = DocVector.withoutIncrementingShardRefCounts(this.encoder.refCounteds(), shardsVector, segmentsVector, docsVector).asBlock();
                success = true;
                docBlock = docsBlock;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    Releasables.closeExpectNoException((Releasable[])new Releasable[]{shardsVector, segmentsVector});
                }
                throw throwable;
            }
            Releasables.closeExpectNoException((Releasable[])new Releasable[]{shardsVector, segmentsVector});
        }
        return docBlock;
    }

    public String toString() {
        return "ValueExtractorForDoc";
    }

    public void close() {
    }
}

