/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;
import org.elasticsearch.core.Releasables;

final class DoubleLookup
implements ReleasableIterator<DoubleBlock> {
    private final DoubleBlock values;
    private final IntBlock positions;
    private final long targetByteSize;
    private int position;
    private double first;
    private int valuesInPosition;

    DoubleLookup(DoubleBlock values, IntBlock positions, ByteSizeValue targetBlockSize) {
        values.incRef();
        positions.incRef();
        this.values = values;
        this.positions = positions;
        this.targetByteSize = targetBlockSize.getBytes();
    }

    public boolean hasNext() {
        return this.position < this.positions.getPositionCount();
    }

    public DoubleBlock next() {
        try (DoubleBlock.Builder builder = this.positions.blockFactory().newDoubleBlockBuilder(this.positions.getTotalValueCount());){
            int count = 0;
            while (this.position < this.positions.getPositionCount()) {
                int start = this.positions.getFirstValueIndex(this.position);
                int end = start + this.positions.getValueCount(this.position);
                this.valuesInPosition = 0;
                for (int i = start; i < end; ++i) {
                    this.copy(builder, this.positions.getInt(i));
                }
                switch (this.valuesInPosition) {
                    case 0: {
                        builder.appendNull();
                        break;
                    }
                    case 1: {
                        builder.appendDouble(this.first);
                        break;
                    }
                    default: {
                        builder.endPositionEntry();
                    }
                }
                ++this.position;
                if (++count <= 32 || builder.estimatedBytes() >= this.targetByteSize) continue;
                break;
            }
            DoubleBlock doubleBlock = builder.build();
            return doubleBlock;
        }
    }

    private void copy(DoubleBlock.Builder builder, int valuePosition) {
        if (valuePosition >= this.values.getPositionCount()) {
            return;
        }
        int start = this.values.getFirstValueIndex(valuePosition);
        int end = start + this.values.getValueCount(valuePosition);
        for (int i = start; i < end; ++i) {
            if (this.valuesInPosition == 0) {
                this.first = this.values.getDouble(i);
                ++this.valuesInPosition;
                continue;
            }
            if (this.valuesInPosition == 1) {
                builder.beginPositionEntry();
                builder.appendDouble(this.first);
            }
            if ((long)this.valuesInPosition > 100000L) {
                throw new IllegalArgumentException("Found a single entry with " + this.valuesInPosition + " entries");
            }
            builder.appendDouble(this.values.getDouble(i));
            ++this.valuesInPosition;
        }
    }

    public void close() {
        Releasables.close((Releasable[])new Releasable[]{this.values, this.positions});
    }
}

