/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.BytesRefArrayBlock;
import org.elasticsearch.compute.data.BytesRefBlockBuilder;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.BytesRefVectorBlock;
import org.elasticsearch.compute.data.ConstantNullBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.OrdinalBytesRefBlock;
import org.elasticsearch.core.ReleasableIterator;
import org.elasticsearch.index.mapper.BlockLoader;

public sealed interface BytesRefBlock
extends Block
permits BytesRefArrayBlock, BytesRefVectorBlock, ConstantNullBlock, OrdinalBytesRefBlock {
    public static final BytesRef NULL_VALUE;

    public BytesRef getBytesRef(int var1, BytesRef var2);

    default public boolean hasValue(int position, BytesRef value, BytesRef scratch) {
        int startIndex;
        int count = this.getValueCount(position);
        for (int index = startIndex = this.getFirstValueIndex(position); index < startIndex + count; ++index) {
            BytesRef ref = this.getBytesRef(index, scratch);
            if (!value.equals((Object)ref)) continue;
            return true;
        }
        return false;
    }

    @Override
    public BytesRefVector asVector();

    public OrdinalBytesRefBlock asOrdinals();

    @Override
    public BytesRefBlock filter(int ... var1);

    @Override
    default public BytesRefBlock deepCopy(BlockFactory blockFactory) {
        try (Builder builder = blockFactory.newBytesRefBlockBuilder(this.getPositionCount());){
            builder.copyFrom(this, 0, this.getPositionCount());
            builder.mvOrdering(this.mvOrdering());
            BytesRefBlock bytesRefBlock = builder.build();
            return bytesRefBlock;
        }
    }

    @Override
    public BytesRefBlock keepMask(BooleanVector var1);

    public ReleasableIterator<? extends BytesRefBlock> lookup(IntBlock var1, ByteSizeValue var2);

    @Override
    public BytesRefBlock expand();

    public static BytesRefBlock readFrom(BlockStreamInput in) throws IOException {
        byte serializationType = in.readByte();
        return switch (serializationType) {
            case 0 -> BytesRefBlock.readValues(in);
            case 1 -> BytesRefVector.readFrom(in.blockFactory(), (StreamInput)in).asBlock();
            case 2 -> BytesRefArrayBlock.readArrayBlock(in.blockFactory(), in);
            case 3 -> OrdinalBytesRefBlock.readOrdinalBlock(in.blockFactory(), in);
            default -> {
                if (!1.$assertionsDisabled) {
                    throw new AssertionError((Object)("invalid block serialization type " + serializationType));
                }
                throw new IllegalStateException("invalid serialization type " + serializationType);
            }
        };
    }

    private static BytesRefBlock readValues(BlockStreamInput in) throws IOException {
        int positions = in.readVInt();
        try (Builder builder = in.blockFactory().newBytesRefBlockBuilder(positions);){
            for (int i = 0; i < positions; ++i) {
                if (in.readBoolean()) {
                    builder.appendNull();
                    continue;
                }
                int valueCount = in.readVInt();
                builder.beginPositionEntry();
                for (int valueIndex = 0; valueIndex < valueCount; ++valueIndex) {
                    builder.appendBytesRef(in.readBytesRef());
                }
                builder.endPositionEntry();
            }
            BytesRefBlock bytesRefBlock = builder.build();
            return bytesRefBlock;
        }
    }

    @Override
    default public void writeTo(StreamOutput out) throws IOException {
        BytesRefVector vector = this.asVector();
        TransportVersion version = out.getTransportVersion();
        if (vector != null) {
            out.writeByte((byte)1);
            vector.writeTo(out);
        } else {
            BytesRefBlock bytesRefBlock = this;
            if (bytesRefBlock instanceof BytesRefArrayBlock) {
                BytesRefArrayBlock b = (BytesRefArrayBlock)bytesRefBlock;
                out.writeByte((byte)2);
                b.writeArrayBlock(out);
            } else {
                OrdinalBytesRefBlock b;
                bytesRefBlock = this;
                if (bytesRefBlock instanceof OrdinalBytesRefBlock && (b = (OrdinalBytesRefBlock)bytesRefBlock).isDense()) {
                    out.writeByte((byte)3);
                    b.writeOrdinalBlock(out);
                } else {
                    out.writeByte((byte)0);
                    BytesRefBlock.writeValues(this, out);
                }
            }
        }
    }

    private static void writeValues(BytesRefBlock block, StreamOutput out) throws IOException {
        int positions = block.getPositionCount();
        out.writeVInt(positions);
        for (int pos = 0; pos < positions; ++pos) {
            if (block.isNull(pos)) {
                out.writeBoolean(true);
                continue;
            }
            out.writeBoolean(false);
            int valueCount = block.getValueCount(pos);
            out.writeVInt(valueCount);
            BytesRef scratch = new BytesRef();
            for (int valueIndex = 0; valueIndex < valueCount; ++valueIndex) {
                out.writeBytesRef(block.getBytesRef(block.getFirstValueIndex(pos) + valueIndex, scratch));
            }
        }
    }

    public boolean equals(Object var1);

    public int hashCode();

    public static boolean equals(BytesRefBlock block1, BytesRefBlock block2) {
        if (block1 == block2) {
            return true;
        }
        int positions = block1.getPositionCount();
        if (positions != block2.getPositionCount()) {
            return false;
        }
        for (int pos = 0; pos < positions; ++pos) {
            if (block1.isNull(pos) || block2.isNull(pos)) {
                if (block1.isNull(pos) == block2.isNull(pos)) continue;
                return false;
            }
            int valueCount = block1.getValueCount(pos);
            if (valueCount != block2.getValueCount(pos)) {
                return false;
            }
            int b1ValueIdx = block1.getFirstValueIndex(pos);
            int b2ValueIdx = block2.getFirstValueIndex(pos);
            for (int valueIndex = 0; valueIndex < valueCount; ++valueIndex) {
                if (block1.getBytesRef(b1ValueIdx + valueIndex, new BytesRef()).equals((Object)block2.getBytesRef(b2ValueIdx + valueIndex, new BytesRef()))) continue;
                return false;
            }
        }
        return true;
    }

    public static int hash(BytesRefBlock block) {
        int positions = block.getPositionCount();
        int result = 1;
        for (int pos = 0; pos < positions; ++pos) {
            if (block.isNull(pos)) {
                result = 31 * result - 1;
                continue;
            }
            int valueCount = block.getValueCount(pos);
            result = 31 * result + valueCount;
            int firstValueIdx = block.getFirstValueIndex(pos);
            for (int valueIndex = 0; valueIndex < valueCount; ++valueIndex) {
                result = 31 * result + block.getBytesRef(firstValueIdx + valueIndex, new BytesRef()).hashCode();
            }
        }
        return result;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        NULL_VALUE = new BytesRef();
    }

    public static sealed interface Builder
    extends Block.Builder,
    BlockLoader.BytesRefBuilder
    permits BytesRefBlockBuilder {
        public Builder appendBytesRef(BytesRef var1);

        public Builder copyFrom(BytesRefBlock var1, int var2, int var3);

        public Builder copyFrom(BytesRefBlock var1, int var2, BytesRef var3);

        @Override
        public Builder appendNull();

        @Override
        public Builder beginPositionEntry();

        @Override
        public Builder endPositionEntry();

        @Override
        public Builder copyFrom(Block var1, int var2, int var3);

        @Override
        public Builder mvOrdering(Block.MvOrdering var1);

        @Override
        public BytesRefBlock build();
    }
}

