/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.spatial;

import java.nio.ByteOrder;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.aggregation.AggregatorState;
import org.elasticsearch.compute.aggregation.spatial.PointType;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.geometry.utils.WellKnownBinary;
import org.elasticsearch.lucene.spatial.CoordinateEncoder;

final class SpatialExtentState
implements AggregatorState {
    private final PointType pointType;
    private boolean seen = false;
    private int minX = Integer.MAX_VALUE;
    private int maxX = Integer.MIN_VALUE;
    private int maxY = Integer.MIN_VALUE;
    private int minY = Integer.MAX_VALUE;

    SpatialExtentState(PointType pointType) {
        this.pointType = pointType;
    }

    public void close() {
    }

    @Override
    public void toIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        assert (blocks.length >= offset + 4);
        BlockFactory blockFactory = driverContext.blockFactory();
        blocks[offset + 0] = blockFactory.newConstantIntBlockWith(this.minX, 1);
        blocks[offset + 1] = blockFactory.newConstantIntBlockWith(this.maxX, 1);
        blocks[offset + 2] = blockFactory.newConstantIntBlockWith(this.maxY, 1);
        blocks[offset + 3] = blockFactory.newConstantIntBlockWith(this.minY, 1);
    }

    public void add(Geometry geo) {
        this.pointType.computeEnvelope(geo).ifPresent(r -> this.add(this.pointType.encoder().encodeX(r.getMinX()), this.pointType.encoder().encodeX(r.getMaxX()), this.pointType.encoder().encodeY(r.getMaxY()), this.pointType.encoder().encodeY(r.getMinY())));
    }

    public void add(int p, IntBlock values) {
        int count = values.getValueCount(p);
        if (count == 6) {
            int i = values.getFirstValueIndex(p);
            int top = values.getInt(i++);
            int bottom = values.getInt(i++);
            int negLeft = values.getInt(i++);
            int negRight = values.getInt(i++);
            int posLeft = values.getInt(i++);
            int posRight = values.getInt(i);
            this.add(Math.min(negLeft, posLeft), Math.max(negRight, posRight), top, bottom);
        } else if (count == 4) {
            int i = values.getFirstValueIndex(p);
            int minX = values.getInt(i++);
            int maxX = values.getInt(i++);
            int maxY = values.getInt(i++);
            int minY = values.getInt(i);
            this.add(minX, maxX, maxY, minY);
        } else {
            throw new IllegalArgumentException("Expected 4 or 6 values, got " + count);
        }
    }

    public void add(int minX, int maxX, int maxY, int minY) {
        this.seen = true;
        this.minX = Math.min(this.minX, minX);
        this.maxX = Math.max(this.maxX, maxX);
        this.maxY = Math.max(this.maxY, maxY);
        this.minY = Math.min(this.minY, minY);
    }

    public void add(long encoded) {
        int x = this.pointType.extractX(encoded);
        int y = this.pointType.extractY(encoded);
        this.add(x, x, y, y);
    }

    public Block toBlock(DriverContext driverContext) {
        BlockFactory factory = driverContext.blockFactory();
        return this.seen ? factory.newConstantBytesRefBlockWith(new BytesRef(this.toWKB()), 1) : factory.newConstantNullBlock(1);
    }

    private byte[] toWKB() {
        CoordinateEncoder encoder = this.pointType.encoder();
        return WellKnownBinary.toWKB((Geometry)new Rectangle(encoder.decodeX(this.minX), encoder.decodeX(this.maxX), encoder.decodeY(this.maxY), encoder.decodeY(this.minY)), (ByteOrder)ByteOrder.LITTLE_ENDIAN);
    }
}

