/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.spatial;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.spatial.SpatialExtentCartesianShapeDocValuesAggregator;
import org.elasticsearch.compute.aggregation.spatial.SpatialExtentState;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class SpatialExtentCartesianShapeDocValuesAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("minX", ElementType.INT), new IntermediateStateDesc("maxX", ElementType.INT), new IntermediateStateDesc("maxY", ElementType.INT), new IntermediateStateDesc("minY", ElementType.INT));
    private final DriverContext driverContext;
    private final SpatialExtentState state;
    private final List<Integer> channels;

    public SpatialExtentCartesianShapeDocValuesAggregatorFunction(DriverContext driverContext, List<Integer> channels, SpatialExtentState state) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
    }

    public static SpatialExtentCartesianShapeDocValuesAggregatorFunction create(DriverContext driverContext, List<Integer> channels) {
        return new SpatialExtentCartesianShapeDocValuesAggregatorFunction(driverContext, channels, SpatialExtentCartesianShapeDocValuesAggregator.initSingle());
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page, BooleanVector mask) {
        if (!mask.allFalse()) {
            if (mask.allTrue()) {
                this.addRawInputNotMasked(page);
            } else {
                this.addRawInputMasked(page, mask);
            }
        }
    }

    private void addRawInputMasked(Page page, BooleanVector mask) {
        IntBlock valuesBlock = (IntBlock)page.getBlock(this.channels.get(0));
        this.addRawBlock(valuesBlock, mask);
    }

    private void addRawInputNotMasked(Page page) {
        IntBlock valuesBlock = (IntBlock)page.getBlock(this.channels.get(0));
        this.addRawBlock(valuesBlock);
    }

    private void addRawBlock(IntBlock valuesBlock) {
        for (int p = 0; p < valuesBlock.getPositionCount(); ++p) {
            int valuesValueCount = valuesBlock.getValueCount(p);
            if (valuesValueCount == 0) continue;
            SpatialExtentCartesianShapeDocValuesAggregator.combine(this.state, p, valuesBlock);
        }
    }

    private void addRawBlock(IntBlock valuesBlock, BooleanVector mask) {
        for (int p = 0; p < valuesBlock.getPositionCount(); ++p) {
            int valuesValueCount;
            if (!mask.getBoolean(p) || (valuesValueCount = valuesBlock.getValueCount(p)) == 0) continue;
            SpatialExtentCartesianShapeDocValuesAggregator.combine(this.state, p, valuesBlock);
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + SpatialExtentCartesianShapeDocValuesAggregatorFunction.intermediateStateDesc().size());
        Object minXUncast = page.getBlock(this.channels.get(0));
        if (minXUncast.areAllValuesNull()) {
            return;
        }
        IntVector minX = ((IntBlock)minXUncast).asVector();
        assert (minX.getPositionCount() == 1);
        Object maxXUncast = page.getBlock(this.channels.get(1));
        if (maxXUncast.areAllValuesNull()) {
            return;
        }
        IntVector maxX = ((IntBlock)maxXUncast).asVector();
        assert (maxX.getPositionCount() == 1);
        Object maxYUncast = page.getBlock(this.channels.get(2));
        if (maxYUncast.areAllValuesNull()) {
            return;
        }
        IntVector maxY = ((IntBlock)maxYUncast).asVector();
        assert (maxY.getPositionCount() == 1);
        Object minYUncast = page.getBlock(this.channels.get(3));
        if (minYUncast.areAllValuesNull()) {
            return;
        }
        IntVector minY = ((IntBlock)minYUncast).asVector();
        assert (minY.getPositionCount() == 1);
        SpatialExtentCartesianShapeDocValuesAggregator.combineIntermediate(this.state, minX.getInt(0), maxX.getInt(0), maxY.getInt(0), minY.getInt(0));
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        blocks[offset] = SpatialExtentCartesianShapeDocValuesAggregator.evaluateFinal(this.state, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

