/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.common.util.BitArray;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntArrayBlock;
import org.elasticsearch.compute.data.IntBigArrayBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public class PresentGroupingAggregatorFunction
implements GroupingAggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("present", ElementType.BOOLEAN));
    private final BitArray state;
    private final List<Integer> channels;
    private final DriverContext driverContext;

    public static PresentGroupingAggregatorFunction create(DriverContext driverContext, List<Integer> inputChannels) {
        return new PresentGroupingAggregatorFunction(inputChannels, new BitArray(1L, driverContext.bigArrays()), driverContext);
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    private PresentGroupingAggregatorFunction(List<Integer> channels, BitArray state, DriverContext driverContext) {
        this.channels = channels;
        this.state = state;
        this.driverContext = driverContext;
    }

    private int blockIndex() {
        return this.channels.get(0);
    }

    @Override
    public int intermediateBlockCount() {
        return PresentGroupingAggregatorFunction.intermediateStateDesc().size();
    }

    @Override
    public GroupingAggregatorFunction.AddInput prepareProcessRawInputPage(SeenGroupIds seenGroupIds, Page page) {
        Object valuesBlock = page.getBlock(this.blockIndex());
        return new GroupingAggregatorFunction.AddInput(){
            final /* synthetic */ Block val$valuesBlock;
            {
                this.val$valuesBlock = block;
            }

            @Override
            public void add(int positionOffset, IntArrayBlock groupIds) {
                PresentGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, this.val$valuesBlock);
            }

            @Override
            public void add(int positionOffset, IntBigArrayBlock groupIds) {
                PresentGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, this.val$valuesBlock);
            }

            @Override
            public void add(int positionOffset, IntVector groupIds) {
                PresentGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, this.val$valuesBlock);
            }

            public void close() {
            }
        };
    }

    private void addRawInput(int positionOffset, IntVector groups, Block values) {
        int position = positionOffset;
        int groupPosition = 0;
        while (groupPosition < groups.getPositionCount()) {
            if (!values.isNull(position)) {
                this.state.set((long)groups.getInt(groupPosition), true);
            }
            ++groupPosition;
            ++position;
        }
    }

    private void addRawInput(int positionOffset, IntArrayBlock groups, Block values) {
        int position = positionOffset;
        int groupPosition = 0;
        while (groupPosition < groups.getPositionCount()) {
            if (!groups.isNull(groupPosition) && !values.isNull(position)) {
                int groupStart = groups.getFirstValueIndex(groupPosition);
                int groupEnd = groupStart + groups.getValueCount(groupPosition);
                for (int g = groupStart; g < groupEnd; ++g) {
                    this.state.set((long)groups.getInt(g), true);
                }
            }
            ++groupPosition;
            ++position;
        }
    }

    private void addRawInput(int positionOffset, IntBigArrayBlock groups, Block values) {
        int position = positionOffset;
        int groupPosition = 0;
        while (groupPosition < groups.getPositionCount()) {
            if (!groups.isNull(groupPosition) && !values.isNull(position)) {
                int groupStart = groups.getFirstValueIndex(groupPosition);
                int groupEnd = groupStart + groups.getValueCount(groupPosition);
                for (int g = groupStart; g < groupEnd; ++g) {
                    this.state.set((long)groups.getInt(g), true);
                }
            }
            ++groupPosition;
            ++position;
        }
    }

    @Override
    public void selectedMayContainUnseenGroups(SeenGroupIds seenGroupIds) {
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntArrayBlock groups, Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.blockIndex() + PresentGroupingAggregatorFunction.intermediateStateDesc().size());
        BooleanVector present = ((BooleanBlock)page.getBlock(this.channels.get(0))).asVector();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition) || !present.getBoolean(groupPosition + positionOffset)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                this.state.set((long)groups.getInt(g), true);
            }
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntBigArrayBlock groups, Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.blockIndex() + PresentGroupingAggregatorFunction.intermediateStateDesc().size());
        BooleanVector present = ((BooleanBlock)page.getBlock(this.channels.get(0))).asVector();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition) || !present.getBoolean(groupPosition + positionOffset)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                this.state.set((long)groups.getInt(g), true);
            }
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntVector groups, Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.blockIndex() + PresentGroupingAggregatorFunction.intermediateStateDesc().size());
        BooleanVector present = ((BooleanBlock)page.getBlock(this.channels.get(0))).asVector();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (!present.getBoolean(groupPosition + positionOffset)) continue;
            this.state.set((long)groups.getInt(groupPosition), true);
        }
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, IntVector selected) {
        try (BooleanVector.FixedBuilder builder = this.driverContext.blockFactory().newBooleanVectorFixedBuilder(selected.getPositionCount());){
            for (int i = 0; i < selected.getPositionCount(); ++i) {
                int group = selected.getInt(i);
                builder.appendBoolean(this.state.get((long)group));
            }
            blocks[offset] = builder.build().asBlock();
        }
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, IntVector selected, GroupingAggregatorEvaluationContext evaluationContext) {
        try (BooleanVector.FixedBuilder builder = evaluationContext.blockFactory().newBooleanVectorFixedBuilder(selected.getPositionCount());){
            for (int i = 0; i < selected.getPositionCount(); ++i) {
                int si = selected.getInt(i);
                builder.appendBoolean(this.state.get((long)si));
            }
            blocks[offset] = builder.build().asBlock();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

