/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.support;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.search.Query;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.support.FieldNameTranslators;

public final class UserBoolQueryBuilder
extends BoolQueryBuilder {
    private static final Set<String> FIELDS_ALLOWED_TO_QUERY = Set.of("_id", User.Fields.TYPE.getPreferredName());

    private UserBoolQueryBuilder() {
    }

    public static UserBoolQueryBuilder build(QueryBuilder queryBuilder) {
        UserBoolQueryBuilder finalQuery = new UserBoolQueryBuilder();
        if (queryBuilder != null) {
            QueryBuilder processedQuery = FieldNameTranslators.USER_FIELD_NAME_TRANSLATORS.translateQueryBuilderFields(queryBuilder, null);
            finalQuery.must(processedQuery);
        }
        finalQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)User.Fields.TYPE.getPreferredName(), (String)"user"));
        return finalQuery;
    }

    protected Query doToQuery(SearchExecutionContext context) throws IOException {
        context.setAllowedFields(this::isIndexFieldNameAllowed);
        return super.doToQuery(context);
    }

    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        if (queryRewriteContext instanceof SearchExecutionContext) {
            ((SearchExecutionContext)queryRewriteContext).setAllowedFields(this::isIndexFieldNameAllowed);
        }
        return super.doRewrite(queryRewriteContext);
    }

    boolean isIndexFieldNameAllowed(String fieldName) {
        return FIELDS_ALLOWED_TO_QUERY.contains(fieldName) || FieldNameTranslators.USER_FIELD_NAME_TRANSLATORS.isIndexFieldSupported(fieldName);
    }
}

