/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.bootstrap.BootstrapContext;
import org.elasticsearch.common.ReferenceDocs;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.ssl.SslConfiguration;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.ssl.SSLService;

class PkiRealmBootstrapCheck
implements BootstrapCheck {
    private final SSLService sslService;

    PkiRealmBootstrapCheck(SSLService sslService) {
        this.sslService = sslService;
    }

    public BootstrapCheck.BootstrapCheckResult check(BootstrapContext context) {
        Settings settings = context.settings();
        Map realms = RealmSettings.getRealmSettings((Settings)settings);
        boolean pkiRealmEnabledWithoutDelegation = realms.entrySet().stream().filter(e -> "pki".equals(((RealmConfig.RealmIdentifier)e.getKey()).getType())).map(Map.Entry::getValue).anyMatch(s -> s.getAsBoolean("enabled", Boolean.valueOf(true)) != false && false == s.getAsBoolean("delegation.enabled", Boolean.valueOf(false)));
        if (pkiRealmEnabledWithoutDelegation) {
            for (String contextName : this.getSslContextNames(settings)) {
                SslConfiguration configuration = this.sslService.getSSLConfiguration(contextName);
                if (!SSLService.isSSLClientAuthEnabled((SslConfiguration)configuration)) continue;
                return BootstrapCheck.BootstrapCheckResult.success();
            }
            return BootstrapCheck.BootstrapCheckResult.failure((String)"a PKI realm is enabled but cannot be used as neither HTTP or Transport have SSL and client authentication enabled");
        }
        return BootstrapCheck.BootstrapCheckResult.success();
    }

    private List<String> getSslContextNames(Settings settings) {
        ArrayList<String> list = new ArrayList<String>();
        if (((Boolean)XPackSettings.HTTP_SSL_ENABLED.get(settings)).booleanValue()) {
            list.add(SecurityField.setting((String)"http.ssl"));
        }
        if (((Boolean)XPackSettings.TRANSPORT_SSL_ENABLED.get(settings)).booleanValue()) {
            list.add(SecurityField.setting((String)"transport.ssl"));
            list.addAll(this.sslService.getTransportProfileContextNames());
        }
        return list;
    }

    public boolean alwaysEnforce() {
        return true;
    }

    public ReferenceDocs referenceDocs() {
        return ReferenceDocs.BOOTSTRAP_CHECK_PKI_REALM;
    }
}

