/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.testclusters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import org.elasticsearch.gradle.FileSystemOperationsAware;
import org.elasticsearch.gradle.testclusters.ElasticsearchCluster;
import org.elasticsearch.gradle.testclusters.TestClustersAware;
import org.elasticsearch.gradle.testclusters.TestClustersThrottle;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.services.internal.BuildServiceProvider;
import org.gradle.api.services.internal.BuildServiceRegistryInternal;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.options.Option;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.resources.SharedResource;

@CacheableTask
public abstract class StandaloneRestIntegTestTask
extends Test
implements TestClustersAware,
FileSystemOperationsAware {
    private Collection<ElasticsearchCluster> clusters = new HashSet<ElasticsearchCluster>();
    private boolean debugServer = false;

    public StandaloneRestIntegTestTask() {
        this.getOutputs().doNotCacheIf("Caching disabled for this task since it is configured to preserve data directory", t -> this.getClusters().stream().anyMatch(cluster -> cluster.isPreserveDataDir()));
    }

    @Option(option="debug-server-jvm", description="Enable debugging configuration, to allow attaching a debugger to elasticsearch.")
    public void setDebugServer(boolean enabled) {
        this.debugServer = enabled;
        this.systemProperty("tests.cluster.debug.enabled", Boolean.toString(enabled));
    }

    @Override
    @Nested
    public Collection<ElasticsearchCluster> getClusters() {
        return this.clusters;
    }

    @Inject
    public abstract ProviderFactory getProviderFactory();

    @Internal
    public List<ResourceLock> getSharedResources() {
        ArrayList<ResourceLock> locks = new ArrayList<ResourceLock>(super.getSharedResources());
        BuildServiceRegistryInternal serviceRegistry = (BuildServiceRegistryInternal)this.getServices().get(BuildServiceRegistryInternal.class);
        BuildServiceProvider serviceProvider = serviceRegistry.consume("testClustersThrottle", TestClustersThrottle.class);
        SharedResource resource = serviceRegistry.forService(serviceProvider);
        int nodeCount = this.clusters.stream().mapToInt(cluster -> cluster.getNodes().size()).sum();
        if (nodeCount > 0) {
            for (int i = 0; i < Math.min(nodeCount, resource.getMaxUsages() - 1); ++i) {
                locks.add(resource.getResourceLock());
            }
        }
        return Collections.unmodifiableList(locks);
    }

    @Override
    public WorkResult delete(Object ... objects) {
        return this.getFileSystemOperations().delete(d -> d.delete(objects));
    }

    @Override
    public void beforeStart() {
        TestClustersAware.super.beforeStart();
        if (this.debugServer) {
            this.enableDebug();
        }
    }
}

