/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.hamcrest;

import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.lucene.spatial.CoordinateEncoder;
import org.hamcrest.Description;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public class RectangleMatcher
extends TypeSafeMatcher<Rectangle> {
    private final Rectangle r;
    private final CoordinateEncoder coordinateEncoder;
    private final double error;

    public static TypeSafeMatcher<Rectangle> closeTo(Rectangle r, double error, CoordinateEncoder coordinateEncoder) {
        return new RectangleMatcher(r, error, coordinateEncoder);
    }

    private RectangleMatcher(Rectangle r, double error, CoordinateEncoder coordinateEncoder) {
        this.r = r;
        this.coordinateEncoder = coordinateEncoder;
        this.error = error;
    }

    public static TypeSafeMatcher<Rectangle> closeToFloat(Rectangle r, double v, CoordinateEncoder encoder) {
        Rectangle normalized = new Rectangle((double)((float)r.getMinX()), (double)((float)r.getMaxX()), (double)((float)r.getMaxY()), (double)((float)r.getMinY()));
        return RectangleMatcher.closeTo(normalized, v, encoder);
    }

    protected boolean matchesSafely(Rectangle other) {
        boolean wrapAroundWorkAround = this.coordinateEncoder == CoordinateEncoder.GEO && this.r.getMinX() >= this.r.getMaxX();
        boolean matchMinX = Matchers.closeTo((double)this.r.getMinX(), (double)this.error).matches((Object)other.getMinX()) || wrapAroundWorkAround && Matchers.closeTo((double)(this.r.getMinX() - 180.0), (double)this.error).matches((Object)other.getMinX()) || wrapAroundWorkAround && Matchers.closeTo((double)this.r.getMinX(), (double)this.error).matches((Object)(other.getMinX() - 180.0));
        boolean matchMaxX = Matchers.closeTo((double)this.r.getMaxX(), (double)this.error).matches((Object)other.getMaxX()) || wrapAroundWorkAround && Matchers.closeTo((double)(this.r.getMaxX() + 180.0), (double)this.error).matches((Object)other.getMaxX()) || wrapAroundWorkAround && Matchers.closeTo((double)this.r.getMaxX(), (double)this.error).matches((Object)(other.getMaxX() + 180.0));
        return matchMinX && matchMaxX && Matchers.closeTo((double)this.r.getMaxY(), (double)this.error).matches((Object)other.getMaxY()) && Matchers.closeTo((double)this.r.getMinY(), (double)this.error).matches((Object)other.getMinY());
    }

    public void describeMismatchSafely(Rectangle rectangle, Description description) {
        description.appendText("was ").appendValue((Object)rectangle);
    }

    public void describeTo(Description description) {
        description.appendValue((Object)("    " + String.valueOf(this.r)));
    }
}

