/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.TimeValue;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class RetryRule
implements TestRule {
    private static final Logger logger = LogManager.getLogger(RetryRule.class);
    private final int maxAttempts;
    private final TimeValue retryDelay;

    public RetryRule(int maxAttempts, TimeValue retryDelay) {
        this.maxAttempts = maxAttempts;
        this.retryDelay = Objects.requireNonNull(retryDelay);
    }

    public Statement apply(final Statement statement, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                Throwable lastThrowable = null;
                for (int i = 0; i < RetryRule.this.maxAttempts; ++i) {
                    try {
                        logger.info(Strings.format((String)"Running test [%s] attempt [%d/%d]", (Object[])new Object[]{description.getMethodName(), i + 1, RetryRule.this.maxAttempts}));
                        statement.evaluate();
                        logger.info(Strings.format((String)"Test [%s] succeeded on attempt [%d/%d]", (Object[])new Object[]{description.getMethodName(), i + 1, RetryRule.this.maxAttempts}));
                        return;
                    }
                    catch (Throwable t) {
                        logger.info(Strings.format((String)"Test [%s] failed with exception: %s, attempt [%d/%d]", (Object[])new Object[]{description.getMethodName(), t.getMessage(), i + 1, RetryRule.this.maxAttempts}));
                        lastThrowable = t;
                        if (i >= RetryRule.this.maxAttempts - 1) continue;
                        TimeUnit.MICROSECONDS.sleep(RetryRule.this.retryDelay.millis());
                        continue;
                    }
                }
                if (lastThrowable != null) {
                    logger.info(Strings.format((String)"Test [%s] failed and exceeded retry limit, failing test.", (Object[])new Object[]{description.getMethodName()}));
                    throw lastThrowable;
                }
            }
        };
    }
}

