/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.telemetry;

import java.util.Objects;
import org.elasticsearch.telemetry.metric.DoubleAsyncCounter;
import org.elasticsearch.telemetry.metric.DoubleCounter;
import org.elasticsearch.telemetry.metric.DoubleGauge;
import org.elasticsearch.telemetry.metric.DoubleHistogram;
import org.elasticsearch.telemetry.metric.DoubleUpDownCounter;
import org.elasticsearch.telemetry.metric.Instrument;
import org.elasticsearch.telemetry.metric.LongAsyncCounter;
import org.elasticsearch.telemetry.metric.LongCounter;
import org.elasticsearch.telemetry.metric.LongGauge;
import org.elasticsearch.telemetry.metric.LongHistogram;
import org.elasticsearch.telemetry.metric.LongUpDownCounter;

public enum InstrumentType {
    DOUBLE_COUNTER(true),
    LONG_COUNTER(false),
    LONG_ASYNC_COUNTER(false),
    DOUBLE_ASYNC_COUNTER(true),
    DOUBLE_UP_DOWN_COUNTER(true),
    LONG_UP_DOWN_COUNTER(false),
    DOUBLE_HISTOGRAM(true),
    LONG_HISTOGRAM(false),
    DOUBLE_GAUGE(true),
    LONG_GAUGE(false);

    public final boolean isDouble;
    public final boolean isLong;

    private InstrumentType(boolean isDouble) {
        this.isDouble = isDouble;
        this.isLong = !isDouble;
    }

    public static InstrumentType fromInstrument(Instrument instrument) {
        Objects.requireNonNull(instrument);
        if (instrument instanceof DoubleCounter) {
            return DOUBLE_COUNTER;
        }
        if (instrument instanceof LongCounter) {
            return LONG_COUNTER;
        }
        if (instrument instanceof LongAsyncCounter) {
            return LONG_ASYNC_COUNTER;
        }
        if (instrument instanceof DoubleAsyncCounter) {
            return DOUBLE_ASYNC_COUNTER;
        }
        if (instrument instanceof DoubleUpDownCounter) {
            return DOUBLE_UP_DOWN_COUNTER;
        }
        if (instrument instanceof LongUpDownCounter) {
            return LONG_UP_DOWN_COUNTER;
        }
        if (instrument instanceof DoubleHistogram) {
            return DOUBLE_HISTOGRAM;
        }
        if (instrument instanceof LongHistogram) {
            return LONG_HISTOGRAM;
        }
        if (instrument instanceof DoubleGauge) {
            return DOUBLE_GAUGE;
        }
        if (instrument instanceof LongGauge) {
            return LONG_GAUGE;
        }
        throw new IllegalArgumentException("unknown instrument [" + instrument.getClass().getName() + "]");
    }
}

