/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotFeatureInfo;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotShardFailure;
import org.elasticsearch.snapshots.SnapshotState;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ContextParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public class SnapshotInfoUtils {
    static final ConstructingObjectParser<CreateSnapshotResponse, Void> CREATE_SNAPSHOT_RESPONSE_PARSER = new ConstructingObjectParser(CreateSnapshotResponse.class.getName(), true, args -> new CreateSnapshotResponse(((SnapshotInfoBuilder)args[0]).build()));
    static final ObjectParser<SnapshotInfoBuilder, Void> SNAPSHOT_INFO_PARSER = new ObjectParser(SnapshotInfoBuilder.class.getName(), true, SnapshotInfoBuilder::new);
    static final ConstructingObjectParser<ShardStatsBuilder, Void> SHARD_STATS_PARSER = new ConstructingObjectParser(ShardStatsBuilder.class.getName(), true, args -> new ShardStatsBuilder(Objects.requireNonNullElse(args[0], 0), Objects.requireNonNullElse(args[1], 0)));

    private SnapshotInfoUtils() {
    }

    public static CreateSnapshotResponse createSnapshotResponseFromXContent(XContentParser parser) {
        return (CreateSnapshotResponse)CREATE_SNAPSHOT_RESPONSE_PARSER.apply(parser, null);
    }

    public static SnapshotInfo snapshotInfoFromXContent(XContentParser parser) {
        return ((SnapshotInfoBuilder)SNAPSHOT_INFO_PARSER.apply(parser, null)).build();
    }

    static {
        SHARD_STATS_PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField("total", new String[0]));
        SHARD_STATS_PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField("successful", new String[0]));
        SNAPSHOT_INFO_PARSER.declareString(SnapshotInfoBuilder::setSnapshotName, new ParseField("snapshot", new String[0]));
        SNAPSHOT_INFO_PARSER.declareString(SnapshotInfoBuilder::setSnapshotUUID, new ParseField("uuid", new String[0]));
        SNAPSHOT_INFO_PARSER.declareString(SnapshotInfoBuilder::setRepository, new ParseField("repository", new String[0]));
        SNAPSHOT_INFO_PARSER.declareString(SnapshotInfoBuilder::setState, new ParseField("state", new String[0]));
        SNAPSHOT_INFO_PARSER.declareString(SnapshotInfoBuilder::setReason, new ParseField("reason", new String[0]));
        SNAPSHOT_INFO_PARSER.declareStringArray(SnapshotInfoBuilder::setIndices, new ParseField("indices", new String[0]));
        SNAPSHOT_INFO_PARSER.declareStringArray(SnapshotInfoBuilder::setDataStreams, new ParseField("data_streams", new String[0]));
        SNAPSHOT_INFO_PARSER.declareObjectArray(SnapshotInfoBuilder::setFeatureStates, (ContextParser)SnapshotFeatureInfo.SNAPSHOT_FEATURE_INFO_PARSER, new ParseField("feature_states", new String[0]));
        SNAPSHOT_INFO_PARSER.declareObject(SnapshotInfoBuilder::setIndexSnapshotDetails, (p, c) -> p.map(HashMap::new, p2 -> (SnapshotInfo.IndexSnapshotDetails)SnapshotInfo.IndexSnapshotDetails.PARSER.parse(p2, c)), new ParseField("index_details", new String[0]));
        SNAPSHOT_INFO_PARSER.declareLong(SnapshotInfoBuilder::setStartTime, new ParseField("start_time_in_millis", new String[0]));
        SNAPSHOT_INFO_PARSER.declareLong(SnapshotInfoBuilder::setEndTime, new ParseField("end_time_in_millis", new String[0]));
        SNAPSHOT_INFO_PARSER.declareObject(SnapshotInfoBuilder::setShardStatsBuilder, SHARD_STATS_PARSER, new ParseField("shards", new String[0]));
        SNAPSHOT_INFO_PARSER.declareBoolean(SnapshotInfoBuilder::setIncludeGlobalState, new ParseField("include_global_state", new String[0]));
        SNAPSHOT_INFO_PARSER.declareObject(SnapshotInfoBuilder::setUserMetadata, (p, c) -> p.map(), new ParseField("metadata", new String[0]));
        SNAPSHOT_INFO_PARSER.declareInt(SnapshotInfoBuilder::setVersion, new ParseField("version_id", new String[0]));
        SNAPSHOT_INFO_PARSER.declareObjectArray(SnapshotInfoBuilder::setShardFailures, (ContextParser)SnapshotShardFailure.SNAPSHOT_SHARD_FAILURE_PARSER, new ParseField("failures", new String[0]));
        CREATE_SNAPSHOT_RESPONSE_PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), SNAPSHOT_INFO_PARSER, new ParseField("snapshot", new String[0]));
    }

    public static final class SnapshotInfoBuilder {
        private String snapshotName = null;
        private String snapshotUUID = null;
        private String repository = "_na_";
        private String state = null;
        private String reason = null;
        private List<String> indices = null;
        private List<String> dataStreams = null;
        private List<SnapshotFeatureInfo> featureStates = null;
        private Map<String, SnapshotInfo.IndexSnapshotDetails> indexSnapshotDetails = null;
        private long startTime = 0L;
        private long endTime = 0L;
        private ShardStatsBuilder shardStatsBuilder = null;
        private Boolean includeGlobalState = null;
        private Map<String, Object> userMetadata = null;
        private int version = -1;
        private List<SnapshotShardFailure> shardFailures = null;

        private void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        private void setSnapshotUUID(String snapshotUUID) {
            this.snapshotUUID = snapshotUUID;
        }

        private void setRepository(String repository) {
            this.repository = repository;
        }

        private void setState(String state) {
            this.state = state;
        }

        private void setReason(String reason) {
            this.reason = reason;
        }

        private void setIndices(List<String> indices) {
            this.indices = indices;
        }

        private void setDataStreams(List<String> dataStreams) {
            this.dataStreams = dataStreams;
        }

        private void setFeatureStates(List<SnapshotFeatureInfo> featureStates) {
            this.featureStates = featureStates;
        }

        private void setIndexSnapshotDetails(Map<String, SnapshotInfo.IndexSnapshotDetails> indexSnapshotDetails) {
            this.indexSnapshotDetails = indexSnapshotDetails;
        }

        private void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        private void setEndTime(long endTime) {
            this.endTime = endTime;
        }

        private void setShardStatsBuilder(ShardStatsBuilder shardStatsBuilder) {
            this.shardStatsBuilder = shardStatsBuilder;
        }

        private void setIncludeGlobalState(Boolean includeGlobalState) {
            this.includeGlobalState = includeGlobalState;
        }

        private void setUserMetadata(Map<String, Object> userMetadata) {
            this.userMetadata = userMetadata;
        }

        private void setVersion(int version) {
            this.version = version;
        }

        private void setShardFailures(List<SnapshotShardFailure> shardFailures) {
            this.shardFailures = shardFailures;
        }

        public SnapshotInfo build() {
            int successfulShards;
            Snapshot snapshot = new Snapshot(this.repository, new SnapshotId(this.snapshotName, this.snapshotUUID));
            if (this.indices == null) {
                this.indices = Collections.emptyList();
            }
            if (this.dataStreams == null) {
                this.dataStreams = Collections.emptyList();
            }
            if (this.featureStates == null) {
                this.featureStates = Collections.emptyList();
            }
            if (this.indexSnapshotDetails == null) {
                this.indexSnapshotDetails = Collections.emptyMap();
            }
            SnapshotState snapshotState = this.state == null ? null : SnapshotState.valueOf((String)this.state);
            IndexVersion version = this.version == -1 ? IndexVersion.current() : IndexVersion.fromId((int)this.version);
            int totalShards = this.shardStatsBuilder == null ? 0 : this.shardStatsBuilder.totalShards();
            int n = successfulShards = this.shardStatsBuilder == null ? 0 : this.shardStatsBuilder.successfulShards();
            if (this.shardFailures == null) {
                this.shardFailures = new ArrayList<SnapshotShardFailure>();
            }
            return new SnapshotInfo(snapshot, this.indices, this.dataStreams, this.featureStates, this.reason, version, this.startTime, this.endTime, totalShards, successfulShards, this.shardFailures, this.includeGlobalState, this.userMetadata, snapshotState, this.indexSnapshotDetails);
        }
    }

    private record ShardStatsBuilder(int totalShards, int successfulShards) {
    }
}

