/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.search.SearchQueryThenFetchAsyncAction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.InternalTestCluster;
import org.elasticsearch.test.MockLog;
import org.elasticsearch.test.transport.MockTransportService;
import org.elasticsearch.transport.BytesTransportResponse;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;
import org.junit.Assert;

public final class ErrorTraceHelper
extends Enum<ErrorTraceHelper> {
    private static final /* synthetic */ ErrorTraceHelper[] $VALUES;

    public static ErrorTraceHelper[] values() {
        return (ErrorTraceHelper[])$VALUES.clone();
    }

    public static ErrorTraceHelper valueOf(String name) {
        return Enum.valueOf(ErrorTraceHelper.class, name);
    }

    public static void assertStackTraceObserved(InternalTestCluster internalTestCluster) {
        ErrorTraceHelper.assertStackTraceObserved(internalTestCluster, true);
    }

    public static void assertStackTraceCleared(InternalTestCluster internalTestCluster) {
        ErrorTraceHelper.assertStackTraceObserved(internalTestCluster, false);
    }

    private static void assertStackTraceObserved(final InternalTestCluster internalCluster, final boolean shouldObserveStackTrace) {
        internalCluster.getDataNodeInstances(TransportService.class).forEach(ts -> ESTestCase.asInstanceOf(MockTransportService.class, ts).addRequestHandlingBehavior("indices:data/read/search[query][n]", (handler, request, channel, task) -> {
            TransportChannel wrappedChannel = new TransportChannel(){

                public String getProfileName() {
                    return channel.getProfileName();
                }

                public void sendResponse(TransportResponse response) {
                    BytesTransportResponse bytes = ESTestCase.asInstanceOf(BytesTransportResponse.class, response);
                    SearchQueryThenFetchAsyncAction.NodeQueryResponse nodeQueryResponse = null;
                    try (StreamInput in = bytes.bytes().streamInput();){
                        NamedWriteableAwareStreamInput namedWriteableAwareInput = new NamedWriteableAwareStreamInput(in, internalCluster.getNamedWriteableRegistry());
                        nodeQueryResponse = new SearchQueryThenFetchAsyncAction.NodeQueryResponse((StreamInput)namedWriteableAwareInput);
                        for (Object result : nodeQueryResponse.getResults()) {
                            if (!(result instanceof Exception)) continue;
                            Exception error = (Exception)result;
                            this.inspectStackTraceAndAssert(error);
                        }
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    finally {
                        if (nodeQueryResponse != null) {
                            nodeQueryResponse.decRef();
                        }
                    }
                    channel.sendResponse(response);
                }

                public void sendResponse(Exception error) {
                    this.inspectStackTraceAndAssert(error);
                    channel.sendResponse(error);
                }

                private void inspectStackTraceAndAssert(Exception error) {
                    ExceptionsHelper.unwrapCausesAndSuppressed((Throwable)error, t -> {
                        if (shouldObserveStackTrace) {
                            Assert.assertTrue((t.getStackTrace().length > 0 ? 1 : 0) != 0);
                        } else {
                            Assert.assertEquals((long)0L, (long)t.getStackTrace().length);
                        }
                        return true;
                    });
                }
            };
            handler.messageReceived(request, wrappedChannel, task);
        }));
    }

    public static void addSeenLoggingExpectations(int numShards, MockLog mockLog, String errorTriggeringIndex) {
        String nodesDisjunction = Strings.format((String)"(%s)", (Object[])new Object[]{Arrays.stream(ESIntegTestCase.internalCluster().getNodeNames()).map(ESIntegTestCase::getNodeId).collect(Collectors.joining("|"))});
        for (int shard = 0; shard < numShards; ++shard) {
            mockLog.addExpectation(new MockLog.PatternAndExceptionSeenEventExpectation(Strings.format((String)"\"[%s][%s][%d]: failed to execute search request for task [\\d+]\" and an exception logged", (Object[])new Object[]{nodesDisjunction, errorTriggeringIndex, shard}), SearchService.class.getCanonicalName(), Level.DEBUG, Strings.format((String)"\\[%s\\]\\[%s\\]\\[%d\\]: failed to execute search request for task \\[\\d+\\]", (Object[])new Object[]{nodesDisjunction, errorTriggeringIndex, shard}), QueryShardException.class, "failed to create query: For input string: \"foo\""));
        }
    }

    private static /* synthetic */ ErrorTraceHelper[] $values() {
        return new ErrorTraceHelper[0];
    }

    static {
        $VALUES = ErrorTraceHelper.$values();
    }
}

