/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.util.List;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.index.seqno.ReplicationTracker;
import org.elasticsearch.index.seqno.RetentionLeases;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetadata;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.recovery.RecoveryTargetHandler;
import org.elasticsearch.repositories.IndexId;

public class AsyncRecoveryTarget
implements RecoveryTargetHandler {
    private final RecoveryTargetHandler target;
    private final Executor executor;

    public AsyncRecoveryTarget(RecoveryTargetHandler target, Executor executor) {
        this.executor = executor;
        this.target = target;
    }

    public void prepareForTranslogOperations(int totalTranslogOps, ActionListener<Void> listener) {
        this.executor.execute(() -> this.target.prepareForTranslogOperations(totalTranslogOps, listener));
    }

    public void finalizeRecovery(long globalCheckpoint, long trimAboveSeqNo, ActionListener<Void> listener) {
        this.executor.execute(() -> this.target.finalizeRecovery(globalCheckpoint, trimAboveSeqNo, listener));
    }

    public void handoffPrimaryContext(ReplicationTracker.PrimaryContext primaryContext, ActionListener<Void> listener) {
        this.executor.execute(() -> this.target.handoffPrimaryContext(primaryContext, listener));
    }

    public void indexTranslogOperations(List<Translog.Operation> operations, int totalTranslogOps, long maxSeenAutoIdTimestampOnPrimary, long maxSeqNoOfDeletesOrUpdatesOnPrimary, RetentionLeases retentionLeases, long mappingVersionOnPrimary, ActionListener<Long> listener) {
        this.executor.execute(() -> this.target.indexTranslogOperations(operations, totalTranslogOps, maxSeenAutoIdTimestampOnPrimary, maxSeqNoOfDeletesOrUpdatesOnPrimary, retentionLeases, mappingVersionOnPrimary, listener));
    }

    public void receiveFileInfo(List<String> phase1FileNames, List<Long> phase1FileSizes, List<String> phase1ExistingFileNames, List<Long> phase1ExistingFileSizes, int totalTranslogOps, ActionListener<Void> listener) {
        this.executor.execute(() -> this.target.receiveFileInfo(phase1FileNames, phase1FileSizes, phase1ExistingFileNames, phase1ExistingFileSizes, totalTranslogOps, listener));
    }

    public void cleanFiles(int totalTranslogOps, long globalCheckpoint, Store.MetadataSnapshot sourceMetadata, ActionListener<Void> listener) {
        this.executor.execute(() -> this.target.cleanFiles(totalTranslogOps, globalCheckpoint, sourceMetadata, listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFileChunk(StoreFileMetadata fileMetadata, long position, ReleasableBytesReference content, boolean lastChunk, int totalTranslogOps, ActionListener<Void> listener) {
        ReleasableBytesReference retained = content.retain();
        ActionListener wrappedListener = ActionListener.runBefore(listener, () -> ((ReleasableBytesReference)retained).close());
        boolean success = false;
        try {
            this.executor.execute(() -> this.target.writeFileChunk(fileMetadata, position, retained, lastChunk, totalTranslogOps, wrappedListener));
            success = true;
        }
        finally {
            if (!success) {
                content.decRef();
            }
        }
    }

    public void restoreFileFromSnapshot(String repository, IndexId indexId, BlobStoreIndexShardSnapshot.FileInfo snapshotFile, ActionListener<Void> listener) {
        this.executor.execute(() -> this.target.restoreFileFromSnapshot(repository, indexId, snapshotFile, listener));
    }
}

