/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.blockloader.docvalues.BlockDocValuesReader;
import org.elasticsearch.test.ESTestCase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class TestBlock
implements BlockLoader.Block {
    private final List<Object> values;

    public static BlockLoader.BlockFactory factory() {
        return new BlockLoader.BlockFactory(){

            public BlockLoader.BooleanBuilder booleansFromDocValues(int expectedCount) {
                return this.booleans(expectedCount);
            }

            public BlockLoader.BooleanBuilder booleans(final int expectedCount) {
                class BooleansBuilder
                extends Builder
                implements BlockLoader.BooleanBuilder {
                    private BooleansBuilder() {
                        super(n);
                    }

                    public BooleansBuilder appendBoolean(boolean value) {
                        this.add(value);
                        return this;
                    }
                }
                return new BooleansBuilder();
            }

            public BlockLoader.BytesRefBuilder bytesRefsFromDocValues(final int expectedCount) {
                class BytesRefsFromDocValuesBuilder
                extends Builder
                implements BlockLoader.BytesRefBuilder {
                    private static final int SINGLE_DOC = 1;

                    private BytesRefsFromDocValuesBuilder() {
                        super(1);
                    }

                    public BytesRefsFromDocValuesBuilder appendBytesRef(BytesRef value) {
                        this.add(BytesRef.deepCopyOf((BytesRef)value));
                        return this;
                    }

                    @Override
                    public TestBlock build() {
                        List<Object> l;
                        TestBlock result = super.build();
                        Object object = result.values.get(0);
                        List<Object> r = object instanceof List ? (l = (List<Object>)object) : List.of(result.values.get(0));
                        ESTestCase.assertThat(r, Matchers.hasSize((int)expectedCount));
                        return result;
                    }
                }
                return new BytesRefsFromDocValuesBuilder();
            }

            public BlockLoader.BytesRefBuilder bytesRefs(final int expectedCount) {
                class BytesRefsBuilder
                extends Builder
                implements BlockLoader.BytesRefBuilder {
                    private BytesRefsBuilder() {
                        super(n);
                    }

                    public BytesRefsBuilder appendBytesRef(BytesRef value) {
                        this.add(BytesRef.deepCopyOf((BytesRef)value));
                        return this;
                    }
                }
                return new BytesRefsBuilder();
            }

            public BlockLoader.DoubleBuilder doublesFromDocValues(int expectedCount) {
                return this.doubles(expectedCount);
            }

            public BlockLoader.DoubleBuilder doubles(final int expectedCount) {
                class DoublesBuilder
                extends Builder
                implements BlockLoader.DoubleBuilder {
                    private DoublesBuilder() {
                        super(n);
                    }

                    public DoublesBuilder appendDouble(double value) {
                        this.add(value);
                        return this;
                    }
                }
                return new DoublesBuilder();
            }

            public BlockLoader.FloatBuilder denseVectors(final int expectedCount, final int dimensions) {
                class FloatsBuilder
                extends Builder
                implements BlockLoader.FloatBuilder {
                    int numElements;

                    private FloatsBuilder() {
                        super(n);
                        this.numElements = 0;
                    }

                    public BlockLoader.FloatBuilder appendFloat(float value) {
                        this.add(Float.valueOf(value));
                        ++this.numElements;
                        return this;
                    }

                    @Override
                    public Builder appendNull() {
                        throw new IllegalArgumentException("dense vectors should not have null values");
                    }

                    @Override
                    public Builder endPositionEntry() {
                        assert (this.numElements == dimensions) : "expected " + dimensions + " dimensions, but got " + this.numElements;
                        this.numElements = 0;
                        return super.endPositionEntry();
                    }

                    @Override
                    public TestBlock build() {
                        assert (this.numElements == 0) : "endPositionEntry() was not called for the last entry";
                        return super.build();
                    }
                }
                return new FloatsBuilder();
            }

            public BlockLoader.IntBuilder intsFromDocValues(int expectedCount) {
                return this.ints(expectedCount);
            }

            public BlockLoader.IntBuilder ints(final int expectedCount) {
                class IntsBuilder
                extends Builder
                implements BlockLoader.IntBuilder {
                    private IntsBuilder() {
                        super(n);
                    }

                    public IntsBuilder appendInt(int value) {
                        this.add(value);
                        return this;
                    }
                }
                return new IntsBuilder();
            }

            public BlockLoader.LongBuilder longsFromDocValues(int expectedCount) {
                return this.longs(expectedCount);
            }

            public BlockLoader.LongBuilder longs(final int expectedCount) {
                class LongsBuilder
                extends Builder
                implements BlockLoader.LongBuilder {
                    private LongsBuilder() {
                        super(n);
                    }

                    public LongsBuilder appendLong(long value) {
                        this.add(value);
                        return this;
                    }
                }
                return new LongsBuilder();
            }

            public BlockLoader.SingletonLongBuilder singletonLongs(int expectedCount) {
                final long[] values = new long[expectedCount];
                return new BlockLoader.SingletonLongBuilder(){
                    private int count;
                    private BlockDocValuesReader.ToDouble toDouble = null;

                    public BlockLoader.Block build() {
                        if (this.toDouble != null) {
                            return new TestBlock(Arrays.stream(values).mapToDouble(arg_0 -> ((BlockDocValuesReader.ToDouble)this.toDouble).convert(arg_0)).boxed().collect(Collectors.toUnmodifiableList()));
                        }
                        return new TestBlock(Arrays.stream(values).boxed().collect(Collectors.toUnmodifiableList()));
                    }

                    public BlockLoader.SingletonLongBuilder appendLongs(long[] newValues, int from, int length) {
                        System.arraycopy(newValues, from, values, this.count, length);
                        this.count += length;
                        return this;
                    }

                    public BlockLoader.SingletonLongBuilder appendLong(long value) {
                        values[this.count++] = value;
                        return this;
                    }

                    public BlockLoader.Builder appendNull() {
                        throw new UnsupportedOperationException();
                    }

                    public BlockLoader.Builder beginPositionEntry() {
                        throw new UnsupportedOperationException();
                    }

                    public BlockLoader.Builder endPositionEntry() {
                        throw new UnsupportedOperationException();
                    }

                    public void close() {
                    }
                };
            }

            public BlockLoader.SingletonIntBuilder singletonInts(int expectedCount) {
                final int[] values = new int[expectedCount];
                return new BlockLoader.SingletonIntBuilder(){
                    private int count;

                    public BlockLoader.Block build() {
                        return new TestBlock(Arrays.stream(values).boxed().collect(Collectors.toUnmodifiableList()));
                    }

                    public BlockLoader.SingletonIntBuilder appendLongs(long[] newValues, int from, int length) {
                        for (int i = 0; i < length; ++i) {
                            values[this.count + i] = Math.toIntExact(newValues[from + i]);
                        }
                        this.count += length;
                        return this;
                    }

                    public BlockLoader.Builder appendNull() {
                        throw new UnsupportedOperationException();
                    }

                    public BlockLoader.Builder beginPositionEntry() {
                        throw new UnsupportedOperationException();
                    }

                    public BlockLoader.Builder endPositionEntry() {
                        throw new UnsupportedOperationException();
                    }

                    public void close() {
                    }
                };
            }

            public BlockLoader.SingletonDoubleBuilder singletonDoubles(int expectedCount) {
                final double[] values = new double[expectedCount];
                return new BlockLoader.SingletonDoubleBuilder(){
                    private int count;

                    public BlockLoader.Block build() {
                        return new TestBlock(Arrays.stream(values).boxed().collect(Collectors.toUnmodifiableList()));
                    }

                    public BlockLoader.SingletonDoubleBuilder appendLongs(BlockDocValuesReader.ToDouble toDouble, long[] longValues, int from, int length) {
                        for (int i = 0; i < length; ++i) {
                            values[this.count + i] = toDouble.convert(longValues[from + i]);
                        }
                        this.count += length;
                        return this;
                    }

                    public BlockLoader.Builder appendNull() {
                        throw new UnsupportedOperationException();
                    }

                    public BlockLoader.Builder beginPositionEntry() {
                        throw new UnsupportedOperationException();
                    }

                    public BlockLoader.Builder endPositionEntry() {
                        throw new UnsupportedOperationException();
                    }

                    public void close() {
                    }
                };
            }

            public BlockLoader.Builder nulls(int expectedCount) {
                return this.longs(expectedCount);
            }

            public BlockLoader.Block constantNulls(int count) {
                BlockLoader.LongBuilder builder = this.longs(count);
                for (int i = 0; i < count; ++i) {
                    builder.appendNull();
                }
                return builder.build();
            }

            public BlockLoader.Block constantBytes(BytesRef value, int count) {
                BlockLoader.BytesRefBuilder builder = this.bytesRefs(count);
                for (int i = 0; i < count; ++i) {
                    builder.appendBytesRef(value);
                }
                return builder.build();
            }

            public BlockLoader.SingletonOrdinalsBuilder singletonOrdinalsBuilder(final SortedDocValues ordinals, final int expectedCount, boolean isDense) {
                class SingletonOrdsBuilder
                extends Builder
                implements BlockLoader.SingletonOrdinalsBuilder {
                    private SingletonOrdsBuilder() {
                        super(n);
                    }

                    public SingletonOrdsBuilder appendOrd(int value) {
                        try {
                            this.add(BytesRef.deepCopyOf((BytesRef)ordinals.lookupOrd(value)));
                            return this;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }

                    public BlockLoader.SingletonOrdinalsBuilder appendOrds(int[] values, int from, int length, int minOrd, int maxOrd) {
                        for (int i = from; i < from + length; ++i) {
                            this.appendOrd(values[i]);
                        }
                        return this;
                    }
                }
                return new SingletonOrdsBuilder();
            }

            public BlockLoader.SortedSetOrdinalsBuilder sortedSetOrdinalsBuilder(final SortedSetDocValues ordinals, final int expectedSize) {
                class SortedSetOrdinalBuilder
                extends Builder
                implements BlockLoader.SortedSetOrdinalsBuilder {
                    private SortedSetOrdinalBuilder() {
                        super(n);
                    }

                    public SortedSetOrdinalBuilder appendOrd(int value) {
                        try {
                            this.add(BytesRef.deepCopyOf((BytesRef)ordinals.lookupOrd((long)value)));
                            return this;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                }
                return new SortedSetOrdinalBuilder();
            }

            public BlockLoader.AggregateMetricDoubleBuilder aggregateMetricDoubleBuilder(int expectedSize) {
                return new AggregateMetricDoubleBlockBuilder(expectedSize);
            }
        };
    }

    public static final BlockLoader.Docs docs(final int ... docs) {
        return new BlockLoader.Docs(){

            public int count() {
                return docs.length;
            }

            public int get(int i) {
                return docs[i];
            }
        };
    }

    public static final BlockLoader.Docs docs(final LeafReaderContext ctx) {
        return new BlockLoader.Docs(){

            public int count() {
                return ctx.reader().numDocs();
            }

            public int get(int i) {
                return i;
            }
        };
    }

    private TestBlock(List<Object> values) {
        this.values = values;
    }

    public Object get(int i) {
        return this.values.get(i);
    }

    public int size() {
        return this.values.size();
    }

    public void close() {
    }

    private static class AggregateMetricDoubleBlockBuilder
    implements BlockLoader.AggregateMetricDoubleBuilder {
        private final DoubleBuilder min;
        private final DoubleBuilder max;
        private final DoubleBuilder sum;
        private final IntBuilder count;

        private AggregateMetricDoubleBlockBuilder(int expectedSize) {
            this.min = new DoubleBuilder(expectedSize);
            this.max = new DoubleBuilder(expectedSize);
            this.sum = new DoubleBuilder(expectedSize);
            this.count = new IntBuilder(expectedSize);
        }

        public BlockLoader.DoubleBuilder min() {
            return this.min;
        }

        public BlockLoader.DoubleBuilder max() {
            return this.max;
        }

        public BlockLoader.DoubleBuilder sum() {
            return this.sum;
        }

        public BlockLoader.IntBuilder count() {
            return this.count;
        }

        public BlockLoader.Block build() {
            TestBlock minBlock = this.min.build();
            TestBlock maxBlock = this.max.build();
            TestBlock sumBlock = this.sum.build();
            TestBlock countBlock = this.count.build();
            assert (minBlock.size() == maxBlock.size());
            assert (maxBlock.size() == sumBlock.size());
            assert (sumBlock.size() == countBlock.size());
            ArrayList<Object> values = new ArrayList<Object>(minBlock.size());
            for (int i = 0; i < minBlock.size(); ++i) {
                HashMap<String, Object> value = new HashMap<String, Object>();
                value.put("min", minBlock.values.get(i));
                value.put("max", maxBlock.values.get(i));
                value.put("sum", sumBlock.values.get(i));
                value.put("value_count", countBlock.values.get(i));
                values.add(value);
            }
            return new TestBlock(values);
        }

        public BlockLoader.Builder appendNull() {
            throw new UnsupportedOperationException();
        }

        public BlockLoader.Builder beginPositionEntry() {
            throw new UnsupportedOperationException();
        }

        public BlockLoader.Builder endPositionEntry() {
            throw new UnsupportedOperationException();
        }

        public void close() {
        }

        private static class DoubleBuilder
        extends Builder
        implements BlockLoader.DoubleBuilder {
            private DoubleBuilder(int expectedSize) {
                super(expectedSize);
            }

            public BlockLoader.DoubleBuilder appendDouble(double value) {
                this.add(value);
                return this;
            }
        }

        private static class IntBuilder
        extends Builder
        implements BlockLoader.IntBuilder {
            private IntBuilder(int expectedSize) {
                super(expectedSize);
            }

            public BlockLoader.IntBuilder appendInt(int value) {
                this.add(value);
                return this;
            }
        }
    }

    private static abstract class Builder
    implements BlockLoader.Builder {
        private final List<Object> values = new ArrayList<Object>();
        private Matcher<Integer> expectedSize;
        private List<Object> currentPosition = null;

        private Builder(int expectedSize) {
            this.expectedSize = Matchers.equalTo((Object)expectedSize);
        }

        public Builder appendNull() {
            Assert.assertNull(this.currentPosition);
            this.values.add(null);
            return this;
        }

        public Builder beginPositionEntry() {
            Assert.assertNull(this.currentPosition);
            this.currentPosition = new ArrayList<Object>();
            this.values.add(this.currentPosition);
            return this;
        }

        public Builder endPositionEntry() {
            Assert.assertNotNull(this.currentPosition);
            this.currentPosition = null;
            return this;
        }

        protected void add(Object value) {
            (this.currentPosition == null ? this.values : this.currentPosition).add(value);
        }

        public TestBlock build() {
            ESTestCase.assertThat(this.values, Matchers.hasSize(this.expectedSize));
            return new TestBlock(this.values);
        }

        public void close() {
        }
    }
}

