/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datageneration.fields.leaf;

import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.datageneration.FieldDataGenerator;
import org.elasticsearch.datageneration.datasource.DataSource;
import org.elasticsearch.datageneration.datasource.DataSourceRequest;
import org.elasticsearch.datageneration.fields.leaf.Wrappers;

public class IntegerFieldDataGenerator
implements FieldDataGenerator {
    private final Supplier<Object> valueGenerator;
    private final Supplier<Object> valueGeneratorWithMalformed;

    public IntegerFieldDataGenerator(String fieldName, DataSource dataSource) {
        Supplier<Integer> ints = dataSource.get(new DataSourceRequest.IntegerGenerator()).generator();
        this.valueGenerator = Wrappers.defaults(ints::get, dataSource);
        Supplier<String> strings = dataSource.get(new DataSourceRequest.StringGenerator()).generator();
        this.valueGeneratorWithMalformed = Wrappers.defaultsWithMalformed(ints::get, strings::get, dataSource);
    }

    @Override
    public Object generateValue(Map<String, Object> fieldMapping) {
        if (fieldMapping != null && ((Boolean)fieldMapping.getOrDefault("ignore_malformed", false)).booleanValue()) {
            return this.valueGeneratorWithMalformed.get();
        }
        return this.valueGenerator.get();
    }
}

