/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datageneration.datasource;

import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.datageneration.FieldType;
import org.elasticsearch.datageneration.datasource.DataSourceHandler;
import org.elasticsearch.datageneration.datasource.DataSourceRequest;
import org.elasticsearch.datageneration.datasource.DataSourceResponse;
import org.elasticsearch.test.ESTestCase;

public class DefaultObjectGenerationHandler
implements DataSourceHandler {
    public static final String RESERVED_FIELD_NAME_PREFIX = "_reserved_";
    private static final Set<FieldType> EXCLUDED_FROM_DYNAMIC_MAPPING = Set.of(FieldType.UNSIGNED_LONG, FieldType.PASSTHROUGH);
    private static final Set<FieldType> ALLOWED_FIELD_TYPES = Arrays.stream(FieldType.values()).filter(fieldType -> !EXCLUDED_FROM_DYNAMIC_MAPPING.contains(fieldType)).collect(Collectors.toSet());

    @Override
    public DataSourceResponse.ChildFieldGenerator handle(final DataSourceRequest.ChildFieldGenerator request) {
        return new DataSourceResponse.ChildFieldGenerator(){

            @Override
            public int generateChildFieldCount() {
                return ESTestCase.randomIntBetween(0, request.specification().maxFieldCountPerLevel());
            }

            @Override
            public boolean generateDynamicSubObject() {
                return ESTestCase.randomDouble() <= 0.05;
            }

            @Override
            public boolean generateNestedSubObject() {
                return ESTestCase.randomDouble() <= 0.05;
            }

            @Override
            public boolean generateRegularSubObject() {
                return ESTestCase.randomDouble() <= 0.05;
            }

            @Override
            public String generateFieldName() {
                String fieldName;
                while ((fieldName = ESTestCase.randomRealisticUnicodeOfCodepointLengthBetween(1, 10)).isBlank() || fieldName.indexOf(46) != -1 || fieldName.startsWith(DefaultObjectGenerationHandler.RESERVED_FIELD_NAME_PREFIX)) {
                }
                return fieldName;
            }
        };
    }

    @Override
    public DataSourceResponse.FieldTypeGenerator handle(DataSourceRequest.FieldTypeGenerator request) {
        return new DataSourceResponse.FieldTypeGenerator(() -> {
            FieldType fieldType = ESTestCase.randomFrom(ALLOWED_FIELD_TYPES);
            return new DataSourceResponse.FieldTypeGenerator.FieldTypeInfo(fieldType.toString());
        });
    }

    @Override
    public DataSourceResponse.ObjectArrayGenerator handle(DataSourceRequest.ObjectArrayGenerator request) {
        return new DataSourceResponse.ObjectArrayGenerator(() -> {
            if (ESTestCase.randomBoolean()) {
                return Optional.of(ESTestCase.randomIntBetween(0, 5));
            }
            return Optional.empty();
        });
    }

    @Override
    public DataSourceResponse.DynamicMappingGenerator handle(DataSourceRequest.DynamicMappingGenerator request) {
        return new DataSourceResponse.DynamicMappingGenerator(isObject -> isObject.booleanValue() ? ESTestCase.randomDouble() <= 0.05 : ESTestCase.randomBoolean());
    }
}

