/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.common.util.CollectionUtils;

public final class RoutingNodesHelper {
    private RoutingNodesHelper() {
    }

    public static int numberOfShardsWithState(RoutingNodes nodes, ShardRoutingState state) {
        assert (state != ShardRoutingState.UNASSIGNED) : "unassigned state is not supported here, use nodes.unassigned().size() instead";
        int count = 0;
        for (RoutingNode routingNode : nodes) {
            count += routingNode.numberOfShardsWithState(state);
        }
        return count;
    }

    public static List<ShardRouting> shardsWithState(RoutingNodes routingNodes, ShardRoutingState state) {
        return state == ShardRoutingState.UNASSIGNED ? CollectionUtils.iterableAsArrayList((Iterable)routingNodes.unassigned()) : routingNodes.stream().flatMap(routingNode -> routingNode.shardsWithState(state)).toList();
    }

    public static List<ShardRouting> shardsWithState(RoutingNodes routingNodes, String index, ShardRoutingState states) {
        return RoutingNodesHelper.shardsWithState(routingNodes, states).stream().filter(shardRouting -> Objects.equals(shardRouting.getIndexName(), index)).toList();
    }

    public static Stream<ShardRouting> assignedShardsIn(RoutingNodes routingNodes) {
        return routingNodes.stream().flatMap(RoutingNodesHelper::assignedShardsIn);
    }

    public static Stream<ShardRouting> assignedShardsIn(RoutingNode routingNode) {
        return StreamSupport.stream(routingNode.spliterator(), false);
    }

    public static Stream<ShardRouting> asStream(IndexShardRoutingTable indexShardRoutingTable) {
        return IntStream.range(0, indexShardRoutingTable.size()).mapToObj(arg_0 -> ((IndexShardRoutingTable)indexShardRoutingTable).shard(arg_0));
    }

    public static RoutingNode routingNode(String nodeId, DiscoveryNode node, ShardRouting ... shards) {
        RoutingNode routingNode = new RoutingNode(nodeId, node, shards.length);
        for (ShardRouting shardRouting : shards) {
            routingNode.add(shardRouting);
        }
        return routingNode;
    }
}

