/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.reroute;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.cluster.reroute.ClusterRerouteRequest;
import org.elasticsearch.action.admin.cluster.reroute.TransportClusterRerouteAction;
import org.elasticsearch.action.support.ActionTestUtils;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.action.support.master.IsAcknowledgedSupplier;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.cluster.routing.allocation.command.AllocationCommand;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;

public class ClusterRerouteUtils {
    private ClusterRerouteUtils() {
    }

    public static void reroute(ElasticsearchClient client, AllocationCommand ... allocationCommands) {
        ClusterRerouteUtils.doReroute(client, false, allocationCommands);
    }

    public static void rerouteRetryFailed(ElasticsearchClient client) {
        ClusterRerouteUtils.doReroute(client, true, new AllocationCommand[0]);
    }

    private static void doReroute(ElasticsearchClient client, boolean retryFailed, AllocationCommand ... allocationCommands) {
        ElasticsearchAssertions.assertAcked((IsAcknowledgedSupplier)ESTestCase.safeGet(client.execute(TransportClusterRerouteAction.TYPE, (ActionRequest)new ClusterRerouteRequest(ESTestCase.TEST_REQUEST_TIMEOUT, ESTestCase.TEST_REQUEST_TIMEOUT).setRetryFailed(retryFailed).add(allocationCommands))));
    }

    public static Exception expectRerouteFailure(ElasticsearchClient client, AllocationCommand ... allocationCommands) {
        Throwable throwable;
        Exception wrappedException = (Exception)ESTestCase.safeAwait(SubscribableListener.newForked(l -> client.execute(TransportClusterRerouteAction.TYPE, (ActionRequest)new ClusterRerouteRequest(ESTestCase.TEST_REQUEST_TIMEOUT, ESTestCase.TEST_REQUEST_TIMEOUT).add(allocationCommands), ActionTestUtils.assertNoSuccessListener(arg_0 -> ((ActionListener)l).onResponse(arg_0)))));
        if (wrappedException instanceof ElasticsearchException) {
            ElasticsearchException esx = (ElasticsearchException)wrappedException;
            throwable = esx.unwrapCause();
        } else {
            throwable = wrappedException;
        }
        return ESTestCase.asInstanceOf(Exception.class, throwable);
    }
}

