/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.exponentialhistogram.aggregations.support;

import java.util.Locale;
import java.util.function.LongSupplier;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.script.AggregationScript;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationErrors;
import org.elasticsearch.search.aggregations.UnsupportedAggregationOnDownsampledIndex;
import org.elasticsearch.search.aggregations.support.FieldContext;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xpack.exponentialhistogram.aggregations.support.ExponentialHistogramValuesSource;
import org.elasticsearch.xpack.exponentialhistogram.fielddata.IndexExponentialHistogramFieldData;

public enum ExponentialHistogramValuesSourceType implements ValuesSourceType
{
    EXPONENTIAL_HISTOGRAM{

        public RuntimeException getUnregisteredException(String message) {
            return new UnsupportedAggregationOnDownsampledIndex(message);
        }

        public ValuesSource getEmpty() {
            throw new IllegalArgumentException("Can't deal with unmapped ExponentialHistogram type " + this.value());
        }

        public ValuesSource getScript(AggregationScript.LeafFactory script, ValueType scriptValueType) {
            throw AggregationErrors.valuesSourceDoesNotSupportScritps((String)this.value());
        }

        public ValuesSource getField(FieldContext fieldContext, AggregationScript.LeafFactory script) {
            IndexFieldData indexFieldData = fieldContext.indexFieldData();
            if (!(indexFieldData instanceof IndexExponentialHistogramFieldData)) {
                throw new IllegalArgumentException("Expected exponential_histogram type on field [" + fieldContext.field() + "], but got [" + fieldContext.fieldType().typeName() + "]");
            }
            return new ExponentialHistogramValuesSource.ExponentialHistogram.Fielddata((IndexExponentialHistogramFieldData)indexFieldData);
        }

        public ValuesSource replaceMissing(ValuesSource valuesSource, Object rawMissing, DocValueFormat docValueFormat, LongSupplier nowInMillis) {
            throw new IllegalArgumentException("Can't apply missing values on a " + String.valueOf(valuesSource.getClass()));
        }
    };


    public String typeName() {
        return this.value();
    }

    public String value() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

