/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.oteldata.otlp.tsid;

import io.opentelemetry.proto.common.v1.KeyValue;
import io.opentelemetry.proto.metrics.v1.ScopeMetrics;
import java.util.List;
import org.elasticsearch.cluster.routing.TsidBuilder;
import org.elasticsearch.xpack.oteldata.otlp.proto.BufferedByteStringAccessor;
import org.elasticsearch.xpack.oteldata.otlp.tsid.AttributeListTsidFunnel;

public class ScopeTsidFunnel
implements TsidBuilder.TsidFunnel<ScopeMetrics> {
    private final BufferedByteStringAccessor byteStringAccessor;

    public ScopeTsidFunnel(BufferedByteStringAccessor byteStringAccessor) {
        this.byteStringAccessor = byteStringAccessor;
    }

    public static TsidBuilder forScope(BufferedByteStringAccessor byteStringAccessor, ScopeMetrics scopeMetrics) {
        TsidBuilder tsidBuilder = new TsidBuilder(scopeMetrics.getScope().getAttributesCount() + 3);
        new ScopeTsidFunnel(byteStringAccessor).add(scopeMetrics, tsidBuilder);
        return tsidBuilder;
    }

    public void add(ScopeMetrics scopeMetrics, TsidBuilder tsidBuilder) {
        List<KeyValue> resourceAttributes = scopeMetrics.getScope().getAttributesList();
        this.byteStringAccessor.addStringDimension(tsidBuilder, "scope.name", scopeMetrics.getScope().getNameBytes());
        tsidBuilder.add(resourceAttributes, (TsidBuilder.TsidFunnel)AttributeListTsidFunnel.get(this.byteStringAccessor, "scope.attributes."));
    }
}

