/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.oteldata.otlp;

import com.google.protobuf.MessageLite;
import io.opentelemetry.proto.collector.metrics.v1.ExportMetricsPartialSuccess;
import io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceRequest;
import io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xpack.oteldata.otlp.datapoint.DataPointGroupingContext;
import org.elasticsearch.xpack.oteldata.otlp.docbuilder.MetricDocumentBuilder;
import org.elasticsearch.xpack.oteldata.otlp.proto.BufferedByteStringAccessor;

public class OTLPMetricsTransportAction
extends HandledTransportAction<MetricsRequest, MetricsResponse> {
    public static final String NAME = "indices:data/write/otlp/metrics";
    public static final ActionType<MetricsResponse> TYPE = new ActionType("indices:data/write/otlp/metrics");
    private static final Logger logger = LogManager.getLogger(OTLPMetricsTransportAction.class);
    private final Client client;

    @Inject
    public OTLPMetricsTransportAction(TransportService transportService, ActionFilters actionFilters, ThreadPool threadPool, Client client) {
        super(NAME, transportService, actionFilters, MetricsRequest::new, (Executor)threadPool.executor("write"));
        this.client = client;
    }

    protected void doExecute(Task task, MetricsRequest request, final ActionListener<MetricsResponse> listener) {
        BufferedByteStringAccessor byteStringAccessor = new BufferedByteStringAccessor();
        final DataPointGroupingContext context = new DataPointGroupingContext(byteStringAccessor);
        try {
            ExportMetricsServiceRequest metricsServiceRequest = ExportMetricsServiceRequest.parseFrom((InputStream)request.exportMetricsServiceRequest.streamInput());
            context.groupDataPoints(metricsServiceRequest);
            if (context.totalDataPoints() == 0) {
                OTLPMetricsTransportAction.handleEmptyRequest(listener);
                return;
            }
            BulkRequestBuilder bulkRequestBuilder = this.client.prepareBulk();
            MetricDocumentBuilder metricDocumentBuilder = new MetricDocumentBuilder(byteStringAccessor);
            context.consume(dataPointGroup -> this.addIndexRequest(bulkRequestBuilder, metricDocumentBuilder, (DataPointGroupingContext.DataPointGroup)dataPointGroup));
            if (bulkRequestBuilder.numberOfActions() == 0) {
                OTLPMetricsTransportAction.handlePartialSuccess(listener, context);
                return;
            }
            bulkRequestBuilder.execute((ActionListener)new ActionListener<BulkResponse>(this){

                public void onResponse(BulkResponse bulkItemResponses) {
                    if (bulkItemResponses.hasFailures() || context.getIgnoredDataPoints() > 0) {
                        OTLPMetricsTransportAction.handlePartialSuccess(bulkItemResponses, context, (ActionListener<MetricsResponse>)listener);
                    } else {
                        OTLPMetricsTransportAction.handleSuccess((ActionListener<MetricsResponse>)listener);
                    }
                }

                public void onFailure(Exception e) {
                    OTLPMetricsTransportAction.handleFailure((ActionListener<MetricsResponse>)listener, e, context);
                }
            });
        }
        catch (Exception e) {
            logger.error("failed to execute otlp metrics request", (Throwable)e);
            OTLPMetricsTransportAction.handleFailure(listener, e, context);
        }
    }

    private void addIndexRequest(BulkRequestBuilder bulkRequestBuilder, MetricDocumentBuilder metricDocumentBuilder, DataPointGroupingContext.DataPointGroup dataPointGroup) throws IOException {
        try (XContentBuilder xContentBuilder = XContentFactory.cborBuilder((OutputStream)new BytesStreamOutput());){
            Map dynamicTemplates = Maps.newHashMapWithExpectedSize((int)dataPointGroup.dataPoints().size());
            BytesRef tsid = metricDocumentBuilder.buildMetricDocument(xContentBuilder, dynamicTemplates, dataPointGroup);
            bulkRequestBuilder.add(new IndexRequest(dataPointGroup.targetIndex().index()).opType(DocWriteRequest.OpType.CREATE).setRequireDataStream(true).source(xContentBuilder).tsid(tsid).setDynamicTemplates(dynamicTemplates));
        }
    }

    private static void handleSuccess(ActionListener<MetricsResponse> listener) {
        listener.onResponse((Object)new MetricsResponse(RestStatus.OK, (MessageLite)ExportMetricsServiceResponse.newBuilder().build()));
    }

    private static void handleEmptyRequest(ActionListener<MetricsResponse> listener) {
        OTLPMetricsTransportAction.handleSuccess(listener);
    }

    private static void handlePartialSuccess(ActionListener<MetricsResponse> listener, DataPointGroupingContext context) {
        ExportMetricsPartialSuccess response = OTLPMetricsTransportAction.responseWithRejectedDataPoints(context.getIgnoredDataPoints(), context.getIgnoredDataPointsMessage());
        listener.onResponse((Object)new MetricsResponse(RestStatus.BAD_REQUEST, (MessageLite)response));
    }

    private static void handlePartialSuccess(BulkResponse bulkItemResponses, DataPointGroupingContext context, ActionListener<MetricsResponse> listener) {
        RestStatus status = RestStatus.OK;
        int failures = 0;
        for (BulkItemResponse bulkItemResponse : bulkItemResponses.getItems()) {
            failures += bulkItemResponse.isFailed() ? 1 : 0;
            if (!bulkItemResponse.isFailed() || bulkItemResponse.getFailure().getStatus() != RestStatus.TOO_MANY_REQUESTS) continue;
            status = RestStatus.TOO_MANY_REQUESTS;
        }
        ExportMetricsPartialSuccess response = OTLPMetricsTransportAction.responseWithRejectedDataPoints(failures + context.getIgnoredDataPoints(), bulkItemResponses.buildFailureMessage() + context.getIgnoredDataPointsMessage());
        listener.onResponse((Object)new MetricsResponse(status, (MessageLite)response));
    }

    private static void handleFailure(ActionListener<MetricsResponse> listener, Exception e, DataPointGroupingContext context) {
        listener.onResponse((Object)new MetricsResponse(ExceptionsHelper.status((Throwable)e), (MessageLite)OTLPMetricsTransportAction.responseWithRejectedDataPoints(context.totalDataPoints(), e.getMessage())));
    }

    private static ExportMetricsPartialSuccess responseWithRejectedDataPoints(int rejectedDataPoints, String message) {
        return ExportMetricsServiceResponse.newBuilder().getPartialSuccessBuilder().setRejectedDataPoints(rejectedDataPoints).setErrorMessage(message).build();
    }

    public static class MetricsRequest
    extends ActionRequest
    implements CompositeIndicesRequest {
        private final BytesReference exportMetricsServiceRequest;

        public MetricsRequest(StreamInput in) throws IOException {
            super(in);
            this.exportMetricsServiceRequest = in.readBytesReference();
        }

        public MetricsRequest(BytesReference exportMetricsServiceRequest) {
            this.exportMetricsServiceRequest = exportMetricsServiceRequest;
        }

        public ActionRequestValidationException validate() {
            return null;
        }
    }

    public static class MetricsResponse
    extends ActionResponse {
        private final BytesReference response;
        private final RestStatus status;

        public MetricsResponse(RestStatus status, MessageLite response) {
            this(status, (BytesReference)new BytesArray(response.toByteArray()));
        }

        public MetricsResponse(RestStatus status, BytesReference response) {
            this.response = response;
            this.status = status;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeBytesReference(this.response);
            out.writeEnum((Enum)this.status);
        }

        public BytesReference getResponse() {
            return this.response;
        }

        public RestStatus getStatus() {
            return this.status;
        }
    }
}

