/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.ml.calendars.Calendar;
import org.elasticsearch.xpack.ml.utils.QueryBuilderHelper;

public class CalendarQueryBuilder {
    private PageParams pageParams = new PageParams(0, 10000);
    private String jobId;
    private List<String> jobGroups = Collections.emptyList();
    private boolean sort = false;
    private String[] idTokens = new String[0];

    public static CalendarQueryBuilder builder() {
        return new CalendarQueryBuilder();
    }

    public CalendarQueryBuilder pageParams(PageParams params) {
        this.pageParams = params;
        return this;
    }

    public CalendarQueryBuilder jobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    public CalendarQueryBuilder jobGroups(List<String> jobGroups) {
        this.jobGroups = jobGroups;
        return this;
    }

    public CalendarQueryBuilder calendarIdTokens(String[] idTokens) {
        this.idTokens = idTokens;
        return this;
    }

    public boolean isForAllCalendars() {
        return Strings.isAllOrWildcard((String[])this.idTokens);
    }

    public Exception buildNotFoundException() {
        return new ResourceNotFoundException("No calendar with id [" + Strings.arrayToCommaDelimitedString((Object[])this.idTokens) + "]", new Object[0]);
    }

    public CalendarQueryBuilder sort(boolean sort) {
        this.sort = sort;
        return this;
    }

    public SearchSourceBuilder build() {
        BoolQueryBuilder qb = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)Calendar.TYPE.getPreferredName(), (String)"calendar"));
        ArrayList<String> jobIdAndGroups = new ArrayList<String>(this.jobGroups);
        if (this.jobId != null) {
            jobIdAndGroups.add(this.jobId);
        }
        if (!jobIdAndGroups.isEmpty()) {
            jobIdAndGroups.add("_all");
            qb.filter((QueryBuilder)new TermsQueryBuilder(Calendar.JOB_IDS.getPreferredName(), jobIdAndGroups));
        }
        QueryBuilderHelper.buildTokenFilterQuery(Calendar.ID.getPreferredName(), this.idTokens).ifPresent(arg_0 -> ((BoolQueryBuilder)qb).filter(arg_0));
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().query((QueryBuilder)qb);
        if (this.sort) {
            sourceBuilder.sort(Calendar.ID.getPreferredName());
        }
        sourceBuilder.from(this.pageParams.getFrom()).size(this.pageParams.getSize());
        return sourceBuilder;
    }
}

