/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.migrate.action;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsAction;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.shard.DocsStats;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskInfo;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.migrate.action.GetMigrationReindexStatusAction;
import org.elasticsearch.xpack.migrate.action.ReindexDataStreamIndexTransportAction;
import org.elasticsearch.xpack.migrate.task.ReindexDataStreamEnrichedStatus;
import org.elasticsearch.xpack.migrate.task.ReindexDataStreamStatus;

public class GetMigrationReindexStatusTransportAction
extends HandledTransportAction<GetMigrationReindexStatusAction.Request, GetMigrationReindexStatusAction.Response> {
    private final ClusterService clusterService;
    private final TransportService transportService;
    private final Client client;
    private final ProjectResolver projectResolver;

    @Inject
    public GetMigrationReindexStatusTransportAction(ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, Client client, ProjectResolver projectResolver) {
        super("indices:admin/migration/reindex_status", transportService, actionFilters, GetMigrationReindexStatusAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.client = client;
        this.projectResolver = projectResolver;
    }

    protected void doExecute(Task task, GetMigrationReindexStatusAction.Request request, ActionListener<GetMigrationReindexStatusAction.Response> listener) {
        String index = request.getIndex();
        String persistentTaskId = "reindex-data-stream-" + index;
        PersistentTasksCustomMetadata.PersistentTask persistentTask = PersistentTasksCustomMetadata.getTaskWithId((ProjectMetadata)this.projectResolver.getProjectMetadata(this.clusterService.state()), (String)persistentTaskId);
        if (persistentTask == null) {
            listener.onFailure((Exception)new ResourceNotFoundException("No migration reindex status found for [{}]", new Object[]{index}));
        } else if (persistentTask.isAssigned()) {
            String nodeId = persistentTask.getExecutorNode();
            if (this.clusterService.localNode().getId().equals(nodeId)) {
                this.fetchAndReportStatusForTaskOnThisNode(persistentTaskId, listener);
            } else {
                this.fetchAndReportStatusForTaskOnRemoteNode(task, request, nodeId, listener);
            }
        } else {
            listener.onFailure((Exception)new ElasticsearchException("Persistent task with id [{}] is not assigned to a node", new Object[]{persistentTaskId}));
        }
    }

    private Task getRunningPersistentTaskFromTaskManager(String persistentTaskId) {
        Optional<Map.Entry> optionalTask = this.taskManager.getCancellableTasks().entrySet().stream().filter(entry -> ((CancellableTask)entry.getValue()).getType().equals("persistent")).filter(entry -> entry.getValue() instanceof AllocatedPersistentTask && persistentTaskId.equals(((AllocatedPersistentTask)entry.getValue()).getPersistentTaskId())).findAny();
        return optionalTask.map(Map.Entry::getValue).orElse(null);
    }

    void fetchAndReportStatusForTaskOnThisNode(String persistentTaskId, ActionListener<GetMigrationReindexStatusAction.Response> listener) {
        Task runningTask = this.getRunningPersistentTaskFromTaskManager(persistentTaskId);
        if (runningTask == null) {
            listener.onFailure((Exception)new ResourceNotFoundException(Strings.format((String)"Persistent task [%s] is supposed to be running on node [%s], but the task is not found on that node", (Object[])new Object[]{persistentTaskId, this.clusterService.localNode().getId()}), new Object[0]));
        } else {
            TaskInfo info = runningTask.taskInfo(this.clusterService.localNode().getId(), true);
            ReindexDataStreamStatus status = (ReindexDataStreamStatus)info.status();
            Set<String> inProgressIndices = status.inProgress();
            if (inProgressIndices.isEmpty()) {
                this.reportStatus(Map.of(), status, listener);
            } else {
                this.fetchInProgressStatsAndReportStatus(inProgressIndices, status, listener);
            }
        }
    }

    private void reportStatus(Map<String, Tuple<Long, Long>> inProgressMap, ReindexDataStreamStatus status, ActionListener<GetMigrationReindexStatusAction.Response> listener) {
        ReindexDataStreamEnrichedStatus enrichedStatus = new ReindexDataStreamEnrichedStatus(status.persistentTaskStartTime(), status.totalIndices(), status.totalIndicesToBeUpgraded(), status.complete(), status.exception(), inProgressMap, status.pending(), status.errors());
        listener.onResponse((Object)new GetMigrationReindexStatusAction.Response(enrichedStatus));
    }

    private void fetchInProgressStatsAndReportStatus(final Set<String> inProgressIndices, final ReindexDataStreamStatus status, final ActionListener<GetMigrationReindexStatusAction.Response> listener) {
        IndicesStatsRequest indicesStatsRequest = new IndicesStatsRequest();
        String[] indices = inProgressIndices.stream().flatMap(index -> Stream.of(index, ReindexDataStreamIndexTransportAction.generateDestIndexName(index))).toList().toArray(new String[0]);
        indicesStatsRequest.indices(indices);
        indicesStatsRequest.indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)true, (boolean)true));
        this.client.execute((ActionType)IndicesStatsAction.INSTANCE, (ActionRequest)indicesStatsRequest, (ActionListener)new ActionListener<IndicesStatsResponse>(){

            public void onResponse(IndicesStatsResponse indicesStatsResponse) {
                HashMap<String, Tuple<Long, Long>> inProgressMap = new HashMap<String, Tuple<Long, Long>>();
                for (String index : inProgressIndices) {
                    DocsStats reindexedDocsStats;
                    DocsStats totalDocsStats;
                    IndexStats sourceIndexStats = indicesStatsResponse.getIndex(index);
                    long totalDocsInIndex = sourceIndexStats == null ? 0L : ((totalDocsStats = sourceIndexStats.getPrimaries().getDocs()) == null ? 0L : totalDocsStats.getCount());
                    IndexStats migratedIndexStats = indicesStatsResponse.getIndex(ReindexDataStreamIndexTransportAction.generateDestIndexName(index));
                    long reindexedDocsInIndex = migratedIndexStats == null ? 0L : ((reindexedDocsStats = migratedIndexStats.getPrimaries().getDocs()) == null ? 0L : reindexedDocsStats.getCount());
                    inProgressMap.put(index, (Tuple<Long, Long>)Tuple.tuple((Object)totalDocsInIndex, (Object)reindexedDocsInIndex));
                }
                GetMigrationReindexStatusTransportAction.this.reportStatus(inProgressMap, status, (ActionListener<GetMigrationReindexStatusAction.Response>)listener);
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    private void fetchAndReportStatusForTaskOnRemoteNode(Task thisTask, GetMigrationReindexStatusAction.Request request, String nodeId, ActionListener<GetMigrationReindexStatusAction.Response> listener) {
        DiscoveryNode node = this.clusterService.state().nodes().get(nodeId);
        if (node == null) {
            listener.onFailure((Exception)new ResourceNotFoundException(Strings.format((String)"Persistent task [%s] is supposed to be running on node [%s], but that node is not part of the cluster", (Object[])new Object[]{request.getIndex(), nodeId}), new Object[0]));
        } else {
            GetMigrationReindexStatusAction.Request nodeRequest = request.nodeRequest(this.clusterService.localNode().getId(), thisTask.getId());
            this.transportService.sendRequest(node, "indices:admin/migration/reindex_status", (TransportRequest)nodeRequest, TransportRequestOptions.EMPTY, (TransportResponseHandler)new ActionListenerResponseHandler(listener, GetMigrationReindexStatusAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE));
        }
    }
}

