/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.predicate.operator.comparison;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.Comparisons;

public class InProcessor
implements Processor {
    public static final String NAME = "in";
    private final List<Processor> processsors;

    InProcessor(List<Processor> processors) {
        this.processsors = processors;
    }

    public InProcessor(StreamInput in) throws IOException {
        this.processsors = in.readNamedWriteableCollectionAsList(Processor.class);
    }

    public String getWriteableName() {
        return NAME;
    }

    public final void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteableCollection(this.processsors);
    }

    @Override
    public Object process(Object input) {
        Object leftValue = this.processsors.get(this.processsors.size() - 1).process(input);
        return InProcessor.apply(leftValue, InProcessor.process(this.processsors.subList(0, this.processsors.size() - 1), leftValue));
    }

    private static List<Object> process(List<Processor> processors, Object input) {
        ArrayList<Object> values = new ArrayList<Object>(processors.size());
        for (Processor p : processors) {
            values.add(p.process(input));
        }
        return values;
    }

    public static Boolean apply(Object input, List<Object> values) {
        Boolean result = Boolean.FALSE;
        for (Object v : values) {
            Boolean compResult = Comparisons.eq(input, v);
            if (compResult == null) {
                result = null;
                continue;
            }
            if (compResult != Boolean.TRUE) continue;
            return Boolean.TRUE;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InProcessor that = (InProcessor)o;
        return Objects.equals(this.processsors, that.processsors);
    }

    public int hashCode() {
        return Objects.hash(this.processsors);
    }
}

