/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.openai.completion;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.inference.services.openai.OpenAiTaskSettings;

public class OpenAiChatCompletionTaskSettings
extends OpenAiTaskSettings<OpenAiChatCompletionTaskSettings> {
    public static final String NAME = "openai_completion_task_settings";
    private static final TransportVersion INFERENCE_API_OPENAI_HEADERS = TransportVersion.fromName((String)"inference_api_openai_headers");

    public OpenAiChatCompletionTaskSettings(Map<String, Object> map) {
        super(map);
    }

    public OpenAiChatCompletionTaskSettings(@Nullable String user, @Nullable Map<String, String> headers) {
        super(user, headers);
    }

    public OpenAiChatCompletionTaskSettings(StreamInput in) throws IOException {
        super(OpenAiChatCompletionTaskSettings.readTaskSettingsFromStream(in));
    }

    private static OpenAiTaskSettings.Settings readTaskSettingsFromStream(StreamInput in) throws IOException {
        String user = in.readOptionalString();
        Map headers = in.getTransportVersion().supports(INFERENCE_API_OPENAI_HEADERS) ? in.readOptionalImmutableMap(StreamInput::readString, StreamInput::readString) : null;
        return OpenAiChatCompletionTaskSettings.createSettings(user, headers);
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_14_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.user());
        if (out.getTransportVersion().supports(INFERENCE_API_OPENAI_HEADERS)) {
            out.writeOptionalMap(this.headers(), StreamOutput::writeString, StreamOutput::writeString);
        }
    }

    @Override
    protected OpenAiChatCompletionTaskSettings create(@Nullable String user, @Nullable Map<String, String> headers) {
        return new OpenAiChatCompletionTaskSettings(user, headers);
    }
}

