/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.llama.completion;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.settings.FilteredXContentObject;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class LlamaChatCompletionServiceSettings
extends FilteredXContentObject
implements ServiceSettings {
    public static final String NAME = "llama_completion_service_settings";
    private static final TransportVersion ML_INFERENCE_LLAMA_ADDED = TransportVersion.fromName((String)"ml_inference_llama_added");
    protected static final RateLimitSettings DEFAULT_RATE_LIMIT_SETTINGS = new RateLimitSettings(3000L);
    private final String modelId;
    private final URI uri;
    private final RateLimitSettings rateLimitSettings;

    public static LlamaChatCompletionServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        ValidationException validationException = new ValidationException();
        String model = ServiceUtils.extractRequiredString(map, "model_id", "service_settings", validationException);
        URI uri = ServiceUtils.extractUri(map, "url", validationException);
        RateLimitSettings rateLimitSettings = RateLimitSettings.of(map, DEFAULT_RATE_LIMIT_SETTINGS, validationException, "llama", context);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new LlamaChatCompletionServiceSettings(model, uri, rateLimitSettings);
    }

    public LlamaChatCompletionServiceSettings(StreamInput in) throws IOException {
        this.modelId = in.readString();
        this.uri = ServiceUtils.createUri(in.readString());
        this.rateLimitSettings = new RateLimitSettings(in);
    }

    public LlamaChatCompletionServiceSettings(String modelId, URI uri, @Nullable RateLimitSettings rateLimitSettings) {
        this.modelId = modelId;
        this.uri = uri;
        this.rateLimitSettings = Objects.requireNonNullElse(rateLimitSettings, DEFAULT_RATE_LIMIT_SETTINGS);
    }

    public LlamaChatCompletionServiceSettings(String modelId, String url, @Nullable RateLimitSettings rateLimitSettings) {
        this(modelId, ServiceUtils.createUri(url), rateLimitSettings);
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return ML_INFERENCE_LLAMA_ADDED;
    }

    public String modelId() {
        return this.modelId;
    }

    public URI uri() {
        return this.uri;
    }

    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitSettings;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.modelId);
        out.writeString(this.uri.toString());
        this.rateLimitSettings.writeTo(out);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentFragmentOfExposedFields(builder, params);
        builder.endObject();
        return builder;
    }

    @Override
    protected XContentBuilder toXContentFragmentOfExposedFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("model_id", this.modelId);
        builder.field("url", this.uri.toString());
        this.rateLimitSettings.toXContent(builder, params);
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LlamaChatCompletionServiceSettings that = (LlamaChatCompletionServiceSettings)o;
        return Objects.equals(this.modelId, that.modelId) && Objects.equals(this.uri, that.uri) && Objects.equals(this.rateLimitSettings, that.rateLimitSettings);
    }

    public int hashCode() {
        return Objects.hash(this.modelId, this.uri, this.rateLimitSettings);
    }
}

