/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.jinaai.response;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.inference.results.DenseEmbeddingBitResults;
import org.elasticsearch.xpack.core.inference.results.DenseEmbeddingByteResults;
import org.elasticsearch.xpack.core.inference.results.DenseEmbeddingFloatResults;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.response.XContentUtils;
import org.elasticsearch.xpack.inference.services.jinaai.embeddings.JinaAIEmbeddingType;
import org.elasticsearch.xpack.inference.services.jinaai.request.JinaAIEmbeddingsRequest;

public class JinaAIEmbeddingsResponseEntity {
    private static final String FAILED_TO_FIND_FIELD_TEMPLATE = "Failed to find required field [%s] in JinaAI embeddings response";
    private static final Map<String, CheckedFunction<XContentParser, InferenceServiceResults, IOException>> EMBEDDING_PARSERS = Map.of(JinaAIEmbeddingType.toLowerCase(JinaAIEmbeddingType.FLOAT), JinaAIEmbeddingsResponseEntity::parseFloatDataObject, JinaAIEmbeddingType.toLowerCase(JinaAIEmbeddingType.BIT), JinaAIEmbeddingsResponseEntity::parseBitDataObject, JinaAIEmbeddingType.toLowerCase(JinaAIEmbeddingType.BINARY), JinaAIEmbeddingsResponseEntity::parseBitDataObject);
    private static final String VALID_EMBEDDING_TYPES_STRING = JinaAIEmbeddingsResponseEntity.supportedEmbeddingTypes();

    private static String supportedEmbeddingTypes() {
        Object[] validTypes = (String[])EMBEDDING_PARSERS.keySet().toArray(String[]::new);
        Arrays.sort(validTypes);
        return String.join((CharSequence)", ", (CharSequence[])validTypes);
    }

    public static InferenceServiceResults fromResponse(Request request, HttpResult response) throws IOException {
        JinaAIEmbeddingsRequest embeddingsRequest = (JinaAIEmbeddingsRequest)request;
        String embeddingType = embeddingsRequest.getEmbeddingType().toString();
        XContentParserConfiguration parserConfig = XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
        CheckedFunction<XContentParser, InferenceServiceResults, IOException> embeddingValueParser = EMBEDDING_PARSERS.get(embeddingType);
        if (embeddingValueParser == null) {
            throw new IllegalStateException(Strings.format((String)"Failed to find a supported embedding type for in the Jina AI embeddings response. Supported types are [%s]", (Object[])new Object[]{VALID_EMBEDDING_TYPES_STRING}));
        }
        try (XContentParser jsonParser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(parserConfig, response.body());){
            XContentUtils.moveToFirstToken(jsonParser);
            XContentParser.Token token = jsonParser.currentToken();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)jsonParser);
            XContentUtils.positionParserAtTokenAfterField(jsonParser, "data", FAILED_TO_FIND_FIELD_TEMPLATE);
            InferenceServiceResults inferenceServiceResults = (InferenceServiceResults)embeddingValueParser.apply((Object)jsonParser);
            return inferenceServiceResults;
        }
    }

    private static InferenceServiceResults parseFloatDataObject(XContentParser jsonParser) throws IOException {
        List embeddingList = XContentParserUtils.parseList((XContentParser)jsonParser, JinaAIEmbeddingsResponseEntity::parseFloatEmbeddingObject);
        return new DenseEmbeddingFloatResults(embeddingList);
    }

    private static DenseEmbeddingFloatResults.Embedding parseFloatEmbeddingObject(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        XContentUtils.positionParserAtTokenAfterField(parser, "embedding", FAILED_TO_FIND_FIELD_TEMPLATE);
        List embeddingValuesList = XContentParserUtils.parseList((XContentParser)parser, XContentUtils::parseFloat);
        XContentUtils.consumeUntilObjectEnd(parser);
        return DenseEmbeddingFloatResults.Embedding.of((List)embeddingValuesList);
    }

    private static InferenceServiceResults parseBitDataObject(XContentParser jsonParser) throws IOException {
        List embeddingList = XContentParserUtils.parseList((XContentParser)jsonParser, JinaAIEmbeddingsResponseEntity::parseBitEmbeddingObject);
        return new DenseEmbeddingBitResults(embeddingList);
    }

    private static DenseEmbeddingByteResults.Embedding parseBitEmbeddingObject(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        XContentUtils.positionParserAtTokenAfterField(parser, "embedding", FAILED_TO_FIND_FIELD_TEMPLATE);
        List embeddingList = XContentParserUtils.parseList((XContentParser)parser, JinaAIEmbeddingsResponseEntity::parseEmbeddingInt8Entry);
        XContentUtils.consumeUntilObjectEnd(parser);
        return DenseEmbeddingByteResults.Embedding.of((List)embeddingList);
    }

    private static Byte parseEmbeddingInt8Entry(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_NUMBER, (XContentParser.Token)token, (XContentParser)parser);
        short parsedByte = parser.shortValue();
        JinaAIEmbeddingsResponseEntity.checkByteBounds(parsedByte);
        return (byte)parsedByte;
    }

    private static void checkByteBounds(short value) {
        if (value < -128 || value > 127) {
            throw new IllegalArgumentException("Value [" + value + "] is out of range for a byte");
        }
    }

    private JinaAIEmbeddingsResponseEntity() {
    }
}

