/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.huggingface.response;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.inference.results.DenseEmbeddingFloatResults;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.response.XContentUtils;

public class HuggingFaceEmbeddingsResponseEntity {
    private static final String FAILED_TO_FIND_FIELD_TEMPLATE = "Failed to find required field [%s] in Hugging Face embeddings response";

    public static DenseEmbeddingFloatResults fromResponse(Request request, HttpResult response) throws IOException {
        XContentParserConfiguration parserConfig = XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
        try (XContentParser jsonParser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(parserConfig, response.body());){
            XContentUtils.moveToFirstToken(jsonParser);
            XContentParser.Token token = jsonParser.currentToken();
            if (token == XContentParser.Token.START_ARRAY) {
                DenseEmbeddingFloatResults denseEmbeddingFloatResults = HuggingFaceEmbeddingsResponseEntity.parseArrayFormat(jsonParser);
                return denseEmbeddingFloatResults;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                DenseEmbeddingFloatResults denseEmbeddingFloatResults = HuggingFaceEmbeddingsResponseEntity.parseObjectFormat(jsonParser);
                return denseEmbeddingFloatResults;
            }
            XContentParserUtils.throwUnknownToken((XContentParser.Token)token, (XContentParser)jsonParser);
        }
        throw new IllegalStateException("Reached an invalid state while parsing the hugging face response");
    }

    private static DenseEmbeddingFloatResults parseArrayFormat(XContentParser parser) throws IOException {
        List embeddingList = XContentParserUtils.parseList((XContentParser)parser, HuggingFaceEmbeddingsResponseEntity::parseEmbeddingEntry);
        return new DenseEmbeddingFloatResults(embeddingList);
    }

    private static DenseEmbeddingFloatResults parseObjectFormat(XContentParser parser) throws IOException {
        XContentUtils.positionParserAtTokenAfterField(parser, "embeddings", FAILED_TO_FIND_FIELD_TEMPLATE);
        List embeddingList = XContentParserUtils.parseList((XContentParser)parser, HuggingFaceEmbeddingsResponseEntity::parseEmbeddingEntry);
        return new DenseEmbeddingFloatResults(embeddingList);
    }

    private static DenseEmbeddingFloatResults.Embedding parseEmbeddingEntry(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        List embeddingValuesList = XContentParserUtils.parseList((XContentParser)parser, XContentUtils::parseFloat);
        return DenseEmbeddingFloatResults.Embedding.of((List)embeddingValuesList);
    }

    private HuggingFaceEmbeddingsResponseEntity() {
    }
}

