/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googlevertexai.embeddings;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.inference.InferenceUtils;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.googlevertexai.GoogleVertexAiRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.FilteredXContentObject;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class GoogleVertexAiEmbeddingsServiceSettings
extends FilteredXContentObject
implements ServiceSettings,
GoogleVertexAiRateLimitServiceSettings {
    public static final String NAME = "google_vertex_ai_embeddings_service_settings";
    public static final String DIMENSIONS_SET_BY_USER = "dimensions_set_by_user";
    private static final RateLimitSettings DEFAULT_RATE_LIMIT_SETTINGS = new RateLimitSettings(30000L);
    private final String location;
    private final String projectId;
    private final String modelId;
    private final Integer dims;
    private final SimilarityMeasure similarity;
    private final Integer maxInputTokens;
    private final RateLimitSettings rateLimitSettings;
    private final Boolean dimensionsSetByUser;

    public static GoogleVertexAiEmbeddingsServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        ValidationException validationException = new ValidationException();
        String location = ServiceUtils.extractRequiredString(map, "location", "service_settings", validationException);
        String projectId = ServiceUtils.extractRequiredString(map, "project_id", "service_settings", validationException);
        String model = ServiceUtils.extractRequiredString(map, "model_id", "service_settings", validationException);
        Integer maxInputTokens = ServiceUtils.extractOptionalPositiveInteger(map, "max_input_tokens", "service_settings", validationException);
        SimilarityMeasure similarityMeasure = ServiceUtils.extractSimilarity(map, "service_settings", validationException);
        Integer dims = ServiceUtils.extractOptionalPositiveInteger(map, "dimensions", "service_settings", validationException);
        RateLimitSettings rateLimitSettings = RateLimitSettings.of(map, DEFAULT_RATE_LIMIT_SETTINGS, validationException, "googlevertexai", context);
        Boolean dimensionsSetByUser = ServiceUtils.extractOptionalBoolean(map, DIMENSIONS_SET_BY_USER, validationException);
        switch (context) {
            case REQUEST: {
                if (dimensionsSetByUser != null) {
                    validationException.addValidationError(ServiceUtils.invalidSettingError(DIMENSIONS_SET_BY_USER, "service_settings"));
                }
                dimensionsSetByUser = dims != null;
                break;
            }
            case PERSISTENT: {
                if (dimensionsSetByUser != null) break;
                validationException.addValidationError(InferenceUtils.missingSettingErrorMsg((String)DIMENSIONS_SET_BY_USER, (String)"service_settings"));
            }
        }
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new GoogleVertexAiEmbeddingsServiceSettings(location, projectId, model, dimensionsSetByUser, maxInputTokens, dims, similarityMeasure, rateLimitSettings);
    }

    public GoogleVertexAiEmbeddingsServiceSettings(String location, String projectId, String modelId, Boolean dimensionsSetByUser, @Nullable Integer maxInputTokens, @Nullable Integer dims, @Nullable SimilarityMeasure similarity, @Nullable RateLimitSettings rateLimitSettings) {
        this.location = location;
        this.projectId = projectId;
        this.modelId = modelId;
        this.dimensionsSetByUser = dimensionsSetByUser;
        this.maxInputTokens = maxInputTokens;
        this.dims = dims;
        this.similarity = Objects.requireNonNullElse(similarity, SimilarityMeasure.DOT_PRODUCT);
        this.rateLimitSettings = Objects.requireNonNullElse(rateLimitSettings, DEFAULT_RATE_LIMIT_SETTINGS);
    }

    public GoogleVertexAiEmbeddingsServiceSettings(StreamInput in) throws IOException {
        this.location = in.readString();
        this.projectId = in.readString();
        this.modelId = in.readString();
        this.dimensionsSetByUser = in.readBoolean();
        this.maxInputTokens = in.readOptionalVInt();
        this.dims = in.readOptionalVInt();
        this.similarity = (SimilarityMeasure)in.readOptionalEnum(SimilarityMeasure.class);
        this.rateLimitSettings = new RateLimitSettings(in);
    }

    @Override
    public String projectId() {
        return this.projectId;
    }

    public String location() {
        return this.location;
    }

    public String modelId() {
        return this.modelId;
    }

    public Boolean dimensionsSetByUser() {
        return this.dimensionsSetByUser;
    }

    @Override
    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitSettings;
    }

    public Integer maxInputTokens() {
        return this.maxInputTokens;
    }

    public Integer dimensions() {
        return this.dims;
    }

    public SimilarityMeasure similarity() {
        return this.similarity;
    }

    public DenseVectorFieldMapper.ElementType elementType() {
        return DenseVectorFieldMapper.ElementType.FLOAT;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentFragmentOfExposedFields(builder, params);
        builder.field(DIMENSIONS_SET_BY_USER, this.dimensionsSetByUser);
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_15_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.location);
        out.writeString(this.projectId);
        out.writeString(this.modelId);
        out.writeBoolean(this.dimensionsSetByUser.booleanValue());
        out.writeOptionalVInt(this.maxInputTokens);
        out.writeOptionalVInt(this.dims);
        out.writeOptionalEnum((Enum)this.similarity);
        this.rateLimitSettings.writeTo(out);
    }

    @Override
    protected XContentBuilder toXContentFragmentOfExposedFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("location", this.location);
        builder.field("project_id", this.projectId);
        builder.field("model_id", this.modelId);
        if (this.maxInputTokens != null) {
            builder.field("max_input_tokens", this.maxInputTokens);
        }
        if (this.dims != null) {
            builder.field("dimensions", this.dims);
        }
        if (this.similarity != null) {
            builder.field("similarity", (Enum)this.similarity);
        }
        this.rateLimitSettings.toXContent(builder, params);
        return builder;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        GoogleVertexAiEmbeddingsServiceSettings that = (GoogleVertexAiEmbeddingsServiceSettings)object;
        return Objects.equals(this.location, that.location) && Objects.equals(this.projectId, that.projectId) && Objects.equals(this.modelId, that.modelId) && Objects.equals(this.dims, that.dims) && this.similarity == that.similarity && Objects.equals(this.maxInputTokens, that.maxInputTokens) && Objects.equals(this.rateLimitSettings, that.rateLimitSettings) && Objects.equals(this.dimensionsSetByUser, that.dimensionsSetByUser);
    }

    public int hashCode() {
        return Objects.hash(this.location, this.projectId, this.modelId, this.dims, this.similarity, this.maxInputTokens, this.rateLimitSettings, this.dimensionsSetByUser);
    }
}

