/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.custom.response;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.inference.results.DenseEmbeddingBitResults;
import org.elasticsearch.xpack.core.inference.results.DenseEmbeddingByteResults;
import org.elasticsearch.xpack.core.inference.results.DenseEmbeddingFloatResults;
import org.elasticsearch.xpack.inference.common.MapPathExtractor;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.custom.CustomServiceEmbeddingType;
import org.elasticsearch.xpack.inference.services.custom.response.BaseCustomResponseParser;

public class DenseEmbeddingResponseParser
extends BaseCustomResponseParser {
    public static final String NAME = "text_embedding_response_parser";
    public static final String TEXT_EMBEDDING_PARSER_EMBEDDINGS = "text_embeddings";
    public static final String EMBEDDING_TYPE = "embedding_type";
    private static final TransportVersion ML_INFERENCE_CUSTOM_SERVICE_EMBEDDING_TYPE = TransportVersion.fromName((String)"ml_inference_custom_service_embedding_type");
    private final String textEmbeddingsPath;
    private final CustomServiceEmbeddingType embeddingType;

    public static DenseEmbeddingResponseParser fromMap(Map<String, Object> responseParserMap, String scope, ValidationException validationException) {
        String jsonParserScope = String.join((CharSequence)".", scope, "json_parser");
        String path = ServiceUtils.extractRequiredString(responseParserMap, TEXT_EMBEDDING_PARSER_EMBEDDINGS, String.join((CharSequence)".", scope, "json_parser"), validationException);
        CustomServiceEmbeddingType embeddingType = Objects.requireNonNullElse(ServiceUtils.extractOptionalEnum(responseParserMap, EMBEDDING_TYPE, jsonParserScope, CustomServiceEmbeddingType::fromString, EnumSet.allOf(CustomServiceEmbeddingType.class), validationException), CustomServiceEmbeddingType.FLOAT);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new DenseEmbeddingResponseParser(path, embeddingType);
    }

    public DenseEmbeddingResponseParser(String textEmbeddingsPath, CustomServiceEmbeddingType embeddingType) {
        this.textEmbeddingsPath = Objects.requireNonNull(textEmbeddingsPath);
        this.embeddingType = Objects.requireNonNull(embeddingType);
    }

    public DenseEmbeddingResponseParser(StreamInput in) throws IOException {
        this.textEmbeddingsPath = in.readString();
        this.embeddingType = in.getTransportVersion().supports(ML_INFERENCE_CUSTOM_SERVICE_EMBEDDING_TYPE) ? (CustomServiceEmbeddingType)in.readEnum(CustomServiceEmbeddingType.class) : CustomServiceEmbeddingType.FLOAT;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.textEmbeddingsPath);
        if (out.getTransportVersion().supports(ML_INFERENCE_CUSTOM_SERVICE_EMBEDDING_TYPE)) {
            out.writeEnum((Enum)this.embeddingType);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("json_parser");
        builder.field(TEXT_EMBEDDING_PARSER_EMBEDDINGS, this.textEmbeddingsPath);
        builder.field(EMBEDDING_TYPE, this.embeddingType.toString());
        builder.endObject();
        return builder;
    }

    String getTextEmbeddingsPath() {
        return this.textEmbeddingsPath;
    }

    @Override
    public CustomServiceEmbeddingType getEmbeddingType() {
        return this.embeddingType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DenseEmbeddingResponseParser that = (DenseEmbeddingResponseParser)o;
        return Objects.equals(this.textEmbeddingsPath, that.textEmbeddingsPath) && Objects.equals((Object)this.embeddingType, (Object)that.embeddingType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.textEmbeddingsPath, this.embeddingType});
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected InferenceServiceResults transform(Map<String, Object> map) {
        MapPathExtractor.Result extractedResult = MapPathExtractor.extract(map, this.textEmbeddingsPath);
        List<?> mapResultsList = DenseEmbeddingResponseParser.validateList(extractedResult.extractedObject(), extractedResult.getArrayFieldName(0));
        EmbeddingConverter embeddingConverter = DenseEmbeddingResponseParser.createEmbeddingConverter(this.embeddingType);
        for (int i = 0; i < mapResultsList.size(); ++i) {
            try {
                Object entry = mapResultsList.get(i);
                embeddingConverter.toEmbedding(entry, extractedResult.getArrayFieldName(1));
                continue;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(Strings.format((String)"Failed to parse text embedding entry [%d], error: %s", (Object[])new Object[]{i, e.getMessage()}), e);
            }
        }
        return embeddingConverter.getResults();
    }

    private static EmbeddingConverter createEmbeddingConverter(CustomServiceEmbeddingType embeddingType) {
        return switch (embeddingType) {
            default -> throw new MatchException(null, null);
            case CustomServiceEmbeddingType.FLOAT -> new FloatEmbeddings();
            case CustomServiceEmbeddingType.BYTE -> new ByteEmbeddings();
            case CustomServiceEmbeddingType.BINARY, CustomServiceEmbeddingType.BIT -> new BitEmbeddings();
        };
    }

    private static interface EmbeddingConverter {
        public void toEmbedding(Object var1, String var2);

        public InferenceServiceResults getResults();
    }

    private static class FloatEmbeddings
    implements EmbeddingConverter {
        private final List<DenseEmbeddingFloatResults.Embedding> embeddings = new ArrayList<DenseEmbeddingFloatResults.Embedding>();

        FloatEmbeddings() {
        }

        @Override
        public void toEmbedding(Object entry, String fieldName) {
            List<Float> embeddingsAsListFloats = BaseCustomResponseParser.convertToListOfFloats(entry, fieldName);
            this.embeddings.add(DenseEmbeddingFloatResults.Embedding.of(embeddingsAsListFloats));
        }

        public DenseEmbeddingFloatResults getResults() {
            return new DenseEmbeddingFloatResults(this.embeddings);
        }
    }

    private static class ByteEmbeddings
    implements EmbeddingConverter {
        private final List<DenseEmbeddingByteResults.Embedding> embeddings = new ArrayList<DenseEmbeddingByteResults.Embedding>();

        ByteEmbeddings() {
        }

        @Override
        public void toEmbedding(Object entry, String fieldName) {
            List<Byte> convertedEmbeddings = BaseCustomResponseParser.convertToListOfBytes(entry, fieldName);
            this.embeddings.add(DenseEmbeddingByteResults.Embedding.of(convertedEmbeddings));
        }

        public DenseEmbeddingByteResults getResults() {
            return new DenseEmbeddingByteResults(this.embeddings);
        }
    }

    private static class BitEmbeddings
    implements EmbeddingConverter {
        private final List<DenseEmbeddingByteResults.Embedding> embeddings = new ArrayList<DenseEmbeddingByteResults.Embedding>();

        BitEmbeddings() {
        }

        @Override
        public void toEmbedding(Object entry, String fieldName) {
            List<Byte> convertedEmbeddings = BaseCustomResponseParser.convertToListOfBits(entry, fieldName);
            this.embeddings.add(DenseEmbeddingByteResults.Embedding.of(convertedEmbeddings));
        }

        public DenseEmbeddingBitResults getResults() {
            return new DenseEmbeddingBitResults(this.embeddings);
        }
    }
}

