/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.anthropic;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.inference.results.StreamingUnifiedChatCompletionResults;
import org.elasticsearch.xpack.inference.common.DelegatingProcessor;
import org.elasticsearch.xpack.inference.external.response.XContentUtils;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEvent;

public class AnthropicChatCompletionStreamingProcessor
extends DelegatingProcessor<Deque<ServerSentEvent>, StreamingUnifiedChatCompletionResults.Results> {
    private static final String FAILED_TO_FIND_FIELD_TEMPLATE = "Failed to find required field [%s] in Anthropic chat completions response";
    private static final Logger logger = LogManager.getLogger(AnthropicChatCompletionStreamingProcessor.class);
    public static final String ROLE_FIELD = "role";
    public static final String INDEX_FIELD = "index";
    public static final String TYPE_FIELD = "type";
    public static final String MODEL_FIELD = "model";
    public static final String ID_FIELD = "id";
    public static final String NAME_FIELD = "name";
    public static final String INPUT_TOKENS_FIELD = "input_tokens";
    public static final String OUTPUT_TOKENS_FIELD = "output_tokens";
    public static final String STOP_REASON_FIELD = "stop_reason";
    public static final String TEXT_FIELD = "text";
    public static final String INPUT_FIELD = "input";
    public static final String PARTIAL_JSON_FIELD = "partial_json";
    public static final String MESSAGE_DELTA_EVENT_TYPE = "message_delta";
    public static final String CONTENT_BLOCK_START_EVENT_TYPE = "content_block_start";
    public static final String MESSAGE_START_EVENT_TYPE = "message_start";
    public static final String VERTEX_EVENT_EVENT_TYPE = "vertex_event";
    public static final String PING_EVENT_TYPE = "ping";
    public static final String CONTENT_BLOCK_STOP_EVENT_TYPE = "content_block_stop";
    public static final String CONTENT_BLOCK_DELTA_EVENT_TYPE = "content_block_delta";
    public static final String MESSAGE_STOP_EVENT_TYPE = "message_stop";
    public static final String ERROR_TYPE = "error";
    public static final String TEXT_DELTA_TYPE = "text_delta";
    public static final String INPUT_JSON_DELTA_TYPE = "input_json_delta";
    public static final String TOOL_USE_TYPE = "tool_use";
    public static final String TEXT_TYPE = "text";
    private final BiFunction<String, Exception, Exception> errorParser;

    public AnthropicChatCompletionStreamingProcessor(BiFunction<String, Exception, Exception> errorParser) {
        this.errorParser = errorParser;
    }

    @Override
    protected void next(Deque<ServerSentEvent> item) throws Exception {
        XContentParserConfiguration parserConfig = XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
        ArrayDeque results = new ArrayDeque(item.size());
        for (ServerSentEvent event : item) {
            if (ERROR_TYPE.equals(event.type()) && event.hasData()) {
                throw this.errorParser.apply(event.data(), null);
            }
            if (!event.hasData()) continue;
            try {
                Stream<StreamingUnifiedChatCompletionResults.ChatCompletionChunk> delta = AnthropicChatCompletionStreamingProcessor.parse(parserConfig, event);
                delta.forEach(results::offer);
            }
            catch (Exception e) {
                logger.warn("Failed to parse event from inference provider: {}", (Object)event);
                throw this.errorParser.apply(event.data(), e);
            }
        }
        if (results.isEmpty()) {
            this.upstream().request(1L);
        } else {
            this.downstream().onNext(new StreamingUnifiedChatCompletionResults.Results(results));
        }
    }

    public static Stream<StreamingUnifiedChatCompletionResults.ChatCompletionChunk> parse(XContentParserConfiguration parserConfig, ServerSentEvent event) throws IOException {
        String string = event.type();
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VERTEX_EVENT_EVENT_TYPE, PING_EVENT_TYPE, CONTENT_BLOCK_STOP_EVENT_TYPE, MESSAGE_START_EVENT_TYPE, CONTENT_BLOCK_START_EVENT_TYPE, CONTENT_BLOCK_DELTA_EVENT_TYPE, MESSAGE_DELTA_EVENT_TYPE, MESSAGE_STOP_EVENT_TYPE}, (Object)string, n)) {
            case 0: 
            case 1: 
            case 2: {
                logger.debug("Skipping event type [{}] for line [{}].", (Object)event.type(), (Object)event.data());
                return Stream.empty();
            }
            case 3: {
                return AnthropicChatCompletionStreamingProcessor.parseMessageStart(parserConfig, event.data());
            }
            case 4: {
                return AnthropicChatCompletionStreamingProcessor.parseContentBlockStart(parserConfig, event.data());
            }
            case 5: {
                return AnthropicChatCompletionStreamingProcessor.parseContentBlockDelta(parserConfig, event.data());
            }
            case 6: {
                return AnthropicChatCompletionStreamingProcessor.parseMessageDelta(parserConfig, event.data());
            }
            case 7: {
                return Stream.empty();
            }
        }
        logger.debug("Unknown event type [{}] for line [{}].", (Object)event.type(), (Object)event.data());
        return Stream.empty();
    }

    public static Stream<StreamingUnifiedChatCompletionResults.ChatCompletionChunk> parseMessageStart(XContentParserConfiguration parserConfig, String data) throws IOException {
        try (XContentParser jsonParser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(parserConfig, data);){
            String id = AnthropicChatCompletionStreamingProcessor.parseStringField(jsonParser, ID_FIELD);
            String role = AnthropicChatCompletionStreamingProcessor.parseStringField(jsonParser, ROLE_FIELD);
            String model = AnthropicChatCompletionStreamingProcessor.parseStringField(jsonParser, MODEL_FIELD);
            String finishReason = AnthropicChatCompletionStreamingProcessor.parseStringOrNullField(jsonParser, STOP_REASON_FIELD);
            int promptTokens = AnthropicChatCompletionStreamingProcessor.parseNumberField(jsonParser, INPUT_TOKENS_FIELD);
            int completionTokens = AnthropicChatCompletionStreamingProcessor.parseNumberField(jsonParser, OUTPUT_TOKENS_FIELD);
            int totalTokens = completionTokens + promptTokens;
            StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Usage usage = new StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Usage(completionTokens, promptTokens, totalTokens);
            StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta delta = new StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta(null, null, role, null);
            StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice choice = new StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice(delta, finishReason, 0);
            StreamingUnifiedChatCompletionResults.ChatCompletionChunk chunk = new StreamingUnifiedChatCompletionResults.ChatCompletionChunk(id, List.of(choice), model, null, usage);
            Stream<StreamingUnifiedChatCompletionResults.ChatCompletionChunk> stream = Stream.of(chunk);
            return stream;
        }
    }

    public static Stream<StreamingUnifiedChatCompletionResults.ChatCompletionChunk> parseContentBlockStart(XContentParserConfiguration parserConfig, String data) throws IOException {
        try (XContentParser jsonParser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(parserConfig, data);){
            StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta delta;
            int index = AnthropicChatCompletionStreamingProcessor.parseNumberField(jsonParser, INDEX_FIELD);
            String type = AnthropicChatCompletionStreamingProcessor.parseStringField(jsonParser, TYPE_FIELD);
            if (type.equals("text")) {
                String text = AnthropicChatCompletionStreamingProcessor.parseStringField(jsonParser, "text");
                delta = new StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta(text, null, null, null);
            } else if (type.equals(TOOL_USE_TYPE)) {
                String id = AnthropicChatCompletionStreamingProcessor.parseStringField(jsonParser, ID_FIELD);
                String name = AnthropicChatCompletionStreamingProcessor.parseStringField(jsonParser, NAME_FIELD);
                Object input = AnthropicChatCompletionStreamingProcessor.parseFieldValue(jsonParser, INPUT_FIELD);
                StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta.ToolCall.Function function = new StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta.ToolCall.Function(input != null ? input.toString() : null, name);
                StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta.ToolCall toolCall = new StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta.ToolCall(0, id, function, null);
                delta = new StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta(null, null, null, List.of(toolCall));
            } else {
                logger.debug("Unknown content block start type [{}] for line [{}].", (Object)type, (Object)data);
                Stream<StreamingUnifiedChatCompletionResults.ChatCompletionChunk> id = Stream.empty();
                return id;
            }
            StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice choice = new StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice(delta, null, index);
            StreamingUnifiedChatCompletionResults.ChatCompletionChunk chunk = new StreamingUnifiedChatCompletionResults.ChatCompletionChunk(null, List.of(choice), null, null, null);
            Stream<StreamingUnifiedChatCompletionResults.ChatCompletionChunk> stream = Stream.of(chunk);
            return stream;
        }
    }

    public static Stream<StreamingUnifiedChatCompletionResults.ChatCompletionChunk> parseContentBlockDelta(XContentParserConfiguration parserConfig, String data) throws IOException {
        try (XContentParser jsonParser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(parserConfig, data);){
            StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta delta;
            int index = AnthropicChatCompletionStreamingProcessor.parseNumberField(jsonParser, INDEX_FIELD);
            String type = AnthropicChatCompletionStreamingProcessor.parseStringField(jsonParser, TYPE_FIELD);
            if (type.equals(TEXT_DELTA_TYPE)) {
                String text = AnthropicChatCompletionStreamingProcessor.parseStringField(jsonParser, "text");
                delta = new StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta(text, null, null, null);
            } else if (type.equals(INPUT_JSON_DELTA_TYPE)) {
                String partialJson = AnthropicChatCompletionStreamingProcessor.parseStringField(jsonParser, PARTIAL_JSON_FIELD);
                StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta.ToolCall.Function function = new StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta.ToolCall.Function(partialJson, null);
                StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta.ToolCall toolCall = new StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta.ToolCall(0, null, function, null);
                delta = new StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta(null, null, null, List.of(toolCall));
            } else {
                logger.debug("Unknown content block delta type [{}] for line [{}].", (Object)type, (Object)data);
                Stream<StreamingUnifiedChatCompletionResults.ChatCompletionChunk> partialJson = Stream.empty();
                return partialJson;
            }
            StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice choice = new StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice(delta, null, index);
            StreamingUnifiedChatCompletionResults.ChatCompletionChunk chunk = new StreamingUnifiedChatCompletionResults.ChatCompletionChunk(null, List.of(choice), null, null, null);
            Stream<StreamingUnifiedChatCompletionResults.ChatCompletionChunk> stream = Stream.of(chunk);
            return stream;
        }
    }

    public static Stream<StreamingUnifiedChatCompletionResults.ChatCompletionChunk> parseMessageDelta(XContentParserConfiguration parserConfig, String data) throws IOException {
        try (XContentParser jsonParser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(parserConfig, data);){
            String finishReason = AnthropicChatCompletionStreamingProcessor.parseStringOrNullField(jsonParser, STOP_REASON_FIELD);
            int totalTokens = AnthropicChatCompletionStreamingProcessor.parseNumberField(jsonParser, OUTPUT_TOKENS_FIELD);
            StreamingUnifiedChatCompletionResults.ChatCompletionChunk chunk = AnthropicChatCompletionStreamingProcessor.buildChatCompletionChunk(totalTokens, finishReason);
            Stream<StreamingUnifiedChatCompletionResults.ChatCompletionChunk> stream = Stream.of(chunk);
            return stream;
        }
    }

    private static StreamingUnifiedChatCompletionResults.ChatCompletionChunk buildChatCompletionChunk(int totalTokens, String finishReason) {
        StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Usage usage = new StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Usage(totalTokens, 0, totalTokens);
        StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice choice = new StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice(new StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta(null, null, null, null), finishReason, 0);
        return new StreamingUnifiedChatCompletionResults.ChatCompletionChunk(null, List.of(choice), null, null, usage);
    }

    private static int parseNumberField(XContentParser jsonParser, String fieldName) throws IOException {
        XContentUtils.positionParserAtTokenAfterField(jsonParser, fieldName, FAILED_TO_FIND_FIELD_TEMPLATE);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_NUMBER, (XContentParser.Token)jsonParser.currentToken(), (XContentParser)jsonParser);
        return jsonParser.intValue();
    }

    private static String parseStringField(XContentParser jsonParser, String fieldName) throws IOException {
        XContentUtils.positionParserAtTokenAfterField(jsonParser, fieldName, FAILED_TO_FIND_FIELD_TEMPLATE);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_STRING, (XContentParser.Token)jsonParser.currentToken(), (XContentParser)jsonParser);
        return jsonParser.text();
    }

    private static String parseStringOrNullField(XContentParser jsonParser, String fieldName) throws IOException {
        XContentUtils.positionParserAtTokenAfterField(jsonParser, fieldName, FAILED_TO_FIND_FIELD_TEMPLATE);
        return jsonParser.textOrNull();
    }

    private static Object parseFieldValue(XContentParser jsonParser, String fieldName) throws IOException {
        XContentUtils.positionParserAtTokenAfterField(jsonParser, fieldName, FAILED_TO_FIND_FIELD_TEMPLATE);
        return XContentParserUtils.parseFieldsValue((XContentParser)jsonParser);
    }
}

