/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ChunkedInference;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.MinimalServiceSettings;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.support.MapXContentParser;
import org.elasticsearch.xpack.core.inference.chunking.ChunkingSettingsBuilder;

public record SemanticTextField(boolean useLegacyFormat, String fieldName, @Nullable List<String> originalValues, InferenceResult inference, XContentType contentType) implements ToXContentObject
{
    @Nullable
    private final List<String> originalValues;
    static final String TEXT_FIELD = "text";
    static final String INFERENCE_FIELD = "inference";
    static final String INFERENCE_ID_FIELD = "inference_id";
    static final String SEARCH_INFERENCE_ID_FIELD = "search_inference_id";
    static final String CHUNKS_FIELD = "chunks";
    static final String CHUNKED_EMBEDDINGS_FIELD = "embeddings";
    public static final String CHUNKED_TEXT_FIELD = "text";
    static final String CHUNKED_OFFSET_FIELD = "offset";
    static final String CHUNKED_START_OFFSET_FIELD = "start_offset";
    static final String CHUNKED_END_OFFSET_FIELD = "end_offset";
    static final String MODEL_SETTINGS_FIELD = "model_settings";
    static final String CHUNKING_SETTINGS_FIELD = "chunking_settings";
    private static final ConstructingObjectParser<SemanticTextField, ParserContext> SEMANTIC_TEXT_FIELD_PARSER = new ConstructingObjectParser("semantic_text", true, (args, context) -> {
        List originalValues = (List)args[0];
        InferenceResult inferenceResult = (InferenceResult)args[1];
        if (!context.useLegacyFormat()) {
            if (originalValues != null && !originalValues.isEmpty()) {
                throw new IllegalArgumentException("Unknown field [text]");
            }
            originalValues = null;
        }
        return new SemanticTextField(context.useLegacyFormat(), context.fieldName(), originalValues, inferenceResult, context.xContentType());
    });
    private static final ConstructingObjectParser<InferenceResult, ParserContext> INFERENCE_RESULT_PARSER = new ConstructingObjectParser("inference", true, args -> {
        String inferenceId = (String)args[0];
        MinimalServiceSettings modelSettings = (MinimalServiceSettings)args[1];
        Map chunkingSettings = (Map)args[2];
        Map chunks = (Map)args[3];
        return new InferenceResult(inferenceId, modelSettings, ChunkingSettingsBuilder.fromMap((Map)chunkingSettings, (boolean)false), chunks);
    });
    private static final ConstructingObjectParser<Chunk, ParserContext> CHUNKS_PARSER = new ConstructingObjectParser("chunks", true, (args, context) -> {
        String text = (String)args[0];
        if (context.useLegacyFormat() && text == null) {
            throw new IllegalArgumentException("Missing chunk text");
        }
        return new Chunk(text, args[1] != null ? (Integer)args[1] : -1, args[2] != null ? (Integer)args[2] : -1, (BytesReference)args[3]);
    });

    public static String getOriginalTextFieldName(String fieldName) {
        return fieldName + ".text";
    }

    public static String getInferenceFieldName(String fieldName) {
        return fieldName + ".inference";
    }

    public static String getChunksFieldName(String fieldName) {
        return SemanticTextField.getInferenceFieldName(fieldName) + ".chunks";
    }

    public static String getEmbeddingsFieldName(String fieldName) {
        return SemanticTextField.getChunksFieldName(fieldName) + ".embeddings";
    }

    public static String getOffsetsFieldName(String fieldName) {
        return SemanticTextField.getChunksFieldName(fieldName) + ".offset";
    }

    static SemanticTextField parse(XContentParser parser, ParserContext context) throws IOException {
        return (SemanticTextField)SEMANTIC_TEXT_FIELD_PARSER.parse(parser, (Object)context);
    }

    static MinimalServiceSettings parseModelSettingsFromMap(Object node) {
        if (node == null) {
            return null;
        }
        try {
            Map map = XContentMapValues.nodeMapValue((Object)node, (String)MODEL_SETTINGS_FIELD);
            MapXContentParser parser = new MapXContentParser(NamedXContentRegistry.EMPTY, DeprecationHandler.IGNORE_DEPRECATIONS, map, XContentType.JSON);
            return MinimalServiceSettings.parse((XContentParser)parser);
        }
        catch (Exception exc) {
            throw new ElasticsearchException((Throwable)exc);
        }
    }

    static ChunkingSettings parseChunkingSettingsFromMap(Object node) {
        if (node == null) {
            return null;
        }
        try {
            Map map = XContentMapValues.nodeMapValue((Object)node, (String)CHUNKING_SETTINGS_FIELD);
            return ChunkingSettingsBuilder.fromMap((Map)map, (boolean)false);
        }
        catch (Exception exc) {
            throw new ElasticsearchException((Throwable)exc);
        }
    }

    public List<String> originalValues() {
        return this.originalValues != null ? this.originalValues : Collections.emptyList();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        List<String> originalValues = this.originalValues();
        if (this.useLegacyFormat && !originalValues.isEmpty()) {
            builder.field("text", originalValues.size() == 1 ? originalValues.get(0) : originalValues);
        }
        builder.startObject(INFERENCE_FIELD);
        builder.field(INFERENCE_ID_FIELD, this.inference.inferenceId);
        builder.field(MODEL_SETTINGS_FIELD, (ToXContent)this.inference.modelSettings);
        if (this.inference.chunkingSettings != null) {
            builder.field(CHUNKING_SETTINGS_FIELD, (ToXContent)this.inference.chunkingSettings);
        }
        if (this.useLegacyFormat) {
            builder.startArray(CHUNKS_FIELD);
        } else {
            builder.startObject(CHUNKS_FIELD);
        }
        for (Map.Entry<String, List<Chunk>> entry : this.inference.chunks.entrySet()) {
            if (!this.useLegacyFormat) {
                builder.startArray(entry.getKey());
            }
            for (Chunk chunk : entry.getValue()) {
                builder.startObject();
                if (this.useLegacyFormat) {
                    builder.field("text", chunk.text);
                } else {
                    builder.field(CHUNKED_START_OFFSET_FIELD, chunk.startOffset);
                    builder.field(CHUNKED_END_OFFSET_FIELD, chunk.endOffset);
                }
                XContentParser parser = XContentHelper.createParserNotCompressed((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)chunk.rawEmbeddings, (XContentType)this.contentType);
                builder.field(CHUNKED_EMBEDDINGS_FIELD).copyCurrentStructure(parser);
                builder.endObject();
            }
            if (this.useLegacyFormat) continue;
            builder.endArray();
        }
        if (this.useLegacyFormat) {
            builder.endArray();
        } else {
            builder.endObject();
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    private static Map<String, List<Chunk>> parseChunksMap(XContentParser parser, ParserContext context) throws IOException {
        LinkedHashMap<String, List<Chunk>> resultMap = new LinkedHashMap<String, List<Chunk>>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            String fieldName = parser.currentName();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
            List chunks = resultMap.computeIfAbsent(fieldName, k -> new ArrayList());
            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                chunks.add((Chunk)CHUNKS_PARSER.parse(parser, (Object)context));
            }
        }
        return resultMap;
    }

    private static List<Chunk> parseChunksArrayLegacy(XContentParser parser, ParserContext context) throws IOException {
        ArrayList<Chunk> results = new ArrayList<Chunk>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            results.add((Chunk)CHUNKS_PARSER.parse(parser, (Object)context));
        }
        return results;
    }

    public static List<Chunk> toSemanticTextFieldChunks(int offsetAdjustment, ChunkedInference results, XContentType contentType) throws IOException {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        Iterator it = results.chunksAsByteReference(contentType.xContent());
        while (it.hasNext()) {
            chunks.add(SemanticTextField.toSemanticTextFieldChunk(offsetAdjustment, (ChunkedInference.Chunk)it.next()));
        }
        return chunks;
    }

    public static Chunk toSemanticTextFieldChunk(int offsetAdjustment, ChunkedInference.Chunk chunk) {
        String text = null;
        int startOffset = chunk.textOffset().start() + offsetAdjustment;
        int endOffset = chunk.textOffset().end() + offsetAdjustment;
        return new Chunk(text, startOffset, endOffset, chunk.bytesReference());
    }

    public static List<Chunk> toSemanticTextFieldChunksLegacy(String input, ChunkedInference results, XContentType contentType) throws IOException {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        Iterator it = results.chunksAsByteReference(contentType.xContent());
        while (it.hasNext()) {
            chunks.add(SemanticTextField.toSemanticTextFieldChunkLegacy(input, (ChunkedInference.Chunk)it.next()));
        }
        return chunks;
    }

    public static Chunk toSemanticTextFieldChunkLegacy(String input, ChunkedInference.Chunk chunk) {
        String text = input.substring(chunk.textOffset().start(), chunk.textOffset().end());
        return new Chunk(text, -1, -1, chunk.bytesReference());
    }

    static {
        SEMANTIC_TEXT_FIELD_PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), new ParseField("text", new String[0]));
        SEMANTIC_TEXT_FIELD_PARSER.declareObject(ConstructingObjectParser.constructorArg(), INFERENCE_RESULT_PARSER, new ParseField(INFERENCE_FIELD, new String[0]));
        INFERENCE_RESULT_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(INFERENCE_ID_FIELD, new String[0]));
        INFERENCE_RESULT_PARSER.declareObjectOrNull(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> MinimalServiceSettings.parse((XContentParser)p), null, new ParseField(MODEL_SETTINGS_FIELD, new String[0]));
        INFERENCE_RESULT_PARSER.declareObjectOrNull(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), null, new ParseField(CHUNKING_SETTINGS_FIELD, new String[0]));
        INFERENCE_RESULT_PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> {
            if (c.useLegacyFormat()) {
                return Map.of(c.fieldName, SemanticTextField.parseChunksArrayLegacy(p, c));
            }
            return SemanticTextField.parseChunksMap(p, c);
        }, new ParseField(CHUNKS_FIELD, new String[0]), ObjectParser.ValueType.OBJECT_ARRAY);
        CHUNKS_PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("text", new String[0]));
        CHUNKS_PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField(CHUNKED_START_OFFSET_FIELD, new String[0]));
        CHUNKS_PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField(CHUNKED_END_OFFSET_FIELD, new String[0]));
        CHUNKS_PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> {
            XContentBuilder b = XContentBuilder.builder((XContent)p.contentType().xContent());
            b.copyCurrentStructure(p);
            return BytesReference.bytes((XContentBuilder)b);
        }, new ParseField(CHUNKED_EMBEDDINGS_FIELD, new String[0]), ObjectParser.ValueType.OBJECT_ARRAY);
    }

    public record InferenceResult(String inferenceId, MinimalServiceSettings modelSettings, ChunkingSettings chunkingSettings, Map<String, List<Chunk>> chunks) {
    }

    public record Chunk(@Nullable String text, int startOffset, int endOffset, BytesReference rawEmbeddings) {
    }

    record ParserContext(boolean useLegacyFormat, String fieldName, XContentType xContentType) {
    }
}

