/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.response.elastic;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.inference.results.DenseEmbeddingFloatResults;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.request.Request;

public class ElasticInferenceServiceDenseTextEmbeddingsResponseEntity {
    public static DenseEmbeddingFloatResults fromResponse(Request request, HttpResult response) throws IOException {
        try (XContentParser p = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(XContentParserConfiguration.EMPTY, response.body());){
            DenseEmbeddingFloatResults denseEmbeddingFloatResults = ((EmbeddingFloatResult)EmbeddingFloatResult.PARSER.apply(p, null)).toDenseEmbeddingFloatResults();
            return denseEmbeddingFloatResults;
        }
    }

    private ElasticInferenceServiceDenseTextEmbeddingsResponseEntity() {
    }

    public record EmbeddingFloatResult(List<EmbeddingFloatResultEntry> embeddingResults) {
        public static final ConstructingObjectParser<EmbeddingFloatResult, Void> PARSER = new ConstructingObjectParser(EmbeddingFloatResult.class.getSimpleName(), true, args -> new EmbeddingFloatResult((List)args[0]));

        public DenseEmbeddingFloatResults toDenseEmbeddingFloatResults() {
            return new DenseEmbeddingFloatResults(this.embeddingResults.stream().map(entry -> DenseEmbeddingFloatResults.Embedding.of(entry.embedding)).toList());
        }

        static {
            PARSER.declareField(ConstructingObjectParser.constructorArg(), (parser, context) -> XContentParserUtils.parseList((XContentParser)parser, (p, index) -> {
                List embedding = XContentParserUtils.parseList((XContentParser)p, (innerParser, innerIndex) -> Float.valueOf(innerParser.floatValue()));
                return EmbeddingFloatResultEntry.fromFloatArray(embedding);
            }), new ParseField("data", new String[0]), ObjectParser.ValueType.OBJECT_ARRAY);
        }
    }

    public record EmbeddingFloatResultEntry(List<Float> embedding) {
        public static EmbeddingFloatResultEntry fromFloatArray(List<Float> floats) {
            return new EmbeddingFloatResultEntry(floats);
        }
    }
}

