/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.rescore;

import java.io.IOException;
import java.util.Comparator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.elasticsearch.search.rescore.RescoreContext;

public interface Rescorer {
    public static final Comparator<ScoreDoc> SCORE_DOC_COMPARATOR = (o1, o2) -> {
        int cmp = Float.compare(o2.score, o1.score);
        return cmp == 0 ? Integer.compare(o1.doc, o2.doc) : cmp;
    };

    public TopDocs rescore(TopDocs var1, IndexSearcher var2, RescoreContext var3) throws IOException;

    public Explanation explain(int var1, IndexSearcher var2, RescoreContext var3, Explanation var4) throws IOException;

    public static TopDocs topN(TopDocs in, int topN) {
        if (in.scoreDocs.length <= topN) {
            return in;
        }
        ScoreDoc[] subset = new ScoreDoc[topN];
        System.arraycopy(in.scoreDocs, 0, subset, 0, topN);
        return new TopDocs(in.totalHits, subset);
    }
}

