/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.crossproject;

import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.common.settings.Settings;

public class CrossProjectModeDecider {
    private static final String CROSS_PROJECT_ENABLED_SETTING_KEY = "serverless.cross_project.enabled";
    private final boolean crossProjectEnabled;

    public CrossProjectModeDecider(Settings settings) {
        this.crossProjectEnabled = settings.getAsBoolean(CROSS_PROJECT_ENABLED_SETTING_KEY, false);
    }

    public boolean crossProjectEnabled() {
        return this.crossProjectEnabled;
    }

    public boolean resolvesCrossProject(IndicesRequest.Replaceable request) {
        if (!this.crossProjectEnabled) {
            return false;
        }
        return request.allowsCrossProject() && request.indicesOptions().resolveCrossProjectIndexExpression();
    }
}

