/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.document;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkRequestParser;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.bulk.IncrementalBulkService;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.CompositeBytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestRefCountedChunkedToXContentListener;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.transport.Transports;
import org.elasticsearch.xcontent.XContentType;

@ServerlessScope(value=Scope.PUBLIC)
public class RestBulkAction
extends BaseRestHandler {
    public static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Specifying types in bulk requests is deprecated.";
    public static final String FAILURE_STORE_STATUS_CAPABILITY = "failure_store_status";
    private final boolean allowExplicitIndex;
    private final IncrementalBulkService bulkHandler;
    private final IncrementalBulkService.Enabled incrementalEnabled;
    private final Set<String> capabilities;

    public RestBulkAction(Settings settings, ClusterSettings clusterSettings, IncrementalBulkService bulkHandler) {
        this.allowExplicitIndex = (Boolean)MULTI_ALLOW_EXPLICIT_INDEX.get(settings);
        this.bulkHandler = bulkHandler;
        this.capabilities = Set.of(FAILURE_STORE_STATUS_CAPABILITY);
        this.incrementalEnabled = new IncrementalBulkService.Enabled(clusterSettings);
    }

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_bulk"), new RestHandler.Route(RestRequest.Method.PUT, "/_bulk"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_bulk"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/_bulk"));
    }

    @Override
    public String getName() {
        return "bulk_action";
    }

    @Override
    public boolean supportsContentStream() {
        return this.incrementalEnabled.get();
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!request.isStreamedContent()) {
            BulkRequest bulkRequest = new BulkRequest();
            String defaultIndex = request.param("index");
            String defaultRouting = request.param("routing");
            FetchSourceContext defaultFetchSourceContext = FetchSourceContext.parseFromRestRequest(request);
            String defaultPipeline = request.param("pipeline");
            boolean defaultListExecutedPipelines = request.paramAsBoolean("list_executed_pipelines", false);
            String waitForActiveShards = request.param("wait_for_active_shards");
            if (waitForActiveShards != null) {
                bulkRequest.waitForActiveShards(ActiveShardCount.parseString(waitForActiveShards));
            }
            Boolean defaultRequireAlias = request.paramAsBoolean("require_alias", false);
            boolean defaultRequireDataStream = request.paramAsBoolean("require_data_stream", false);
            bulkRequest.timeout(request.paramAsTime("timeout", BulkShardRequest.DEFAULT_TIMEOUT));
            bulkRequest.setRefreshPolicy(request.param("refresh"));
            bulkRequest.includeSourceOnError(RestUtils.getIncludeSourceOnError(request));
            bulkRequest.requestParamsUsed(request.params().keySet());
            ReleasableBytesReference content = request.requiredContent();
            try {
                bulkRequest.add(content, defaultIndex, defaultRouting, defaultFetchSourceContext, defaultPipeline, defaultRequireAlias, defaultRequireDataStream, defaultListExecutedPipelines, this.allowExplicitIndex, request.getXContentType(), request.getRestApiVersion());
            }
            catch (Exception e) {
                return channel -> new RestToXContentListener((RestChannel)channel).onFailure(RestBulkAction.parseFailureException(e));
            }
            return channel -> {
                content.mustIncRef();
                client.bulk(bulkRequest, ActionListener.releaseAfter(new RestRefCountedChunkedToXContentListener((RestChannel)channel), content));
            };
        }
        request.ensureContent();
        String waitForActiveShards = request.param("wait_for_active_shards");
        TimeValue timeout = request.paramAsTime("timeout", BulkShardRequest.DEFAULT_TIMEOUT);
        String refresh = request.param("refresh");
        return new ChunkHandler(this.allowExplicitIndex, request, () -> this.bulkHandler.newBulkRequest(waitForActiveShards, timeout, refresh, request.params().keySet()));
    }

    private static Exception parseFailureException(Exception e) {
        if (e instanceof IllegalArgumentException) {
            return e;
        }
        return new ElasticsearchParseException("could not parse bulk request body", (Throwable)e, new Object[0]);
    }

    @Override
    public Set<String> supportedCapabilities() {
        return this.capabilities;
    }

    @Override
    public boolean mediaTypesValid(RestRequest request) {
        return super.mediaTypesValid(request) && XContentType.supportsDelimitedBulkRequests((XContentType)request.getXContentType());
    }

    static class ChunkHandler
    implements BaseRestHandler.RequestBodyChunkConsumer {
        private final RestRequest request;
        private final Supplier<IncrementalBulkService.Handler> handlerSupplier;
        private final BulkRequestParser.IncrementalParser parser;
        private IncrementalBulkService.Handler handler;
        private volatile RestChannel restChannel;
        private boolean shortCircuited;
        private final ArrayDeque<ReleasableBytesReference> unParsedChunks = new ArrayDeque(4);
        private final ArrayList<DocWriteRequest<?>> items = new ArrayList(4);
        private long requestNextChunkTime;
        private long totalChunkWaitTimeInNanos = 0L;

        ChunkHandler(boolean allowExplicitIndex, RestRequest request, Supplier<IncrementalBulkService.Handler> handlerSupplier) {
            this.request = request;
            this.handlerSupplier = handlerSupplier;
            this.parser = new BulkRequestParser(true, RestUtils.getIncludeSourceOnError(request), request.getRestApiVersion()).incrementalParser(request.param("index"), request.param("routing"), FetchSourceContext.parseFromRestRequest(request), request.param("pipeline"), request.paramAsBoolean("require_alias", false), request.paramAsBoolean("require_data_stream", false), request.paramAsBoolean("list_executed_pipelines", false), allowExplicitIndex, request.getXContentType(), (indexRequest, type) -> this.items.add((DocWriteRequest<?>)indexRequest), this.items::add, this.items::add);
        }

        public void accept(RestChannel restChannel) {
            this.restChannel = restChannel;
            this.handler = this.handlerSupplier.get();
            this.requestNextChunkTime = System.nanoTime();
            this.request.contentStream().next();
        }

        @Override
        public void handleChunk(RestChannel channel, ReleasableBytesReference chunk, boolean isLast) {
            int bytesConsumed;
            assert (this.handler != null);
            assert (channel == this.restChannel);
            long now = System.nanoTime();
            long elapsedTime = now - this.requestNextChunkTime;
            if (elapsedTime > 0L) {
                this.totalChunkWaitTimeInNanos += elapsedTime;
                this.requestNextChunkTime = now;
            }
            if (this.shortCircuited) {
                chunk.close();
                return;
            }
            if (chunk.length() == 0) {
                chunk.close();
                bytesConsumed = 0;
            } else {
                try {
                    this.handler.getIncrementalOperation().incrementUnparsedBytes(chunk.length());
                    this.unParsedChunks.add(chunk);
                    BytesReference data = this.unParsedChunks.size() > 1 ? CompositeBytesReference.of(this.unParsedChunks.toArray(new ReleasableBytesReference[0])) : chunk;
                    bytesConsumed = this.parser.parse(data, isLast);
                    this.handler.getIncrementalOperation().transferUnparsedBytesToParsed(bytesConsumed);
                }
                catch (Exception e) {
                    this.shortCircuit();
                    new RestToXContentListener(channel).onFailure(RestBulkAction.parseFailureException(e));
                    return;
                }
            }
            ArrayList<Releasable> releasables = this.accountParsing(bytesConsumed);
            if (isLast) {
                assert (this.unParsedChunks.isEmpty());
                if (this.handler.getIncrementalOperation().totalParsedBytes() == 0L) {
                    this.shortCircuit();
                    new RestToXContentListener(channel).onFailure(new ElasticsearchParseException("request body is required", new Object[0]));
                } else {
                    assert (channel != null);
                    ArrayList toPass = new ArrayList(this.items);
                    this.items.clear();
                    this.handler.lastItems(toPass, () -> Releasables.close((Iterable)releasables), new RestRefCountedChunkedToXContentListener<BulkResponse>(channel));
                }
                this.handler.updateWaitForChunkMetrics(TimeUnit.NANOSECONDS.toMillis(this.totalChunkWaitTimeInNanos));
                this.totalChunkWaitTimeInNanos = 0L;
            } else if (!this.items.isEmpty()) {
                ArrayList toPass = new ArrayList(this.items);
                this.items.clear();
                this.handler.addItems(toPass, () -> Releasables.close((Iterable)releasables), () -> {
                    this.requestNextChunkTime = System.nanoTime();
                    this.request.contentStream().next();
                });
            } else {
                Releasables.close(releasables);
                this.requestNextChunkTime = System.nanoTime();
                this.request.contentStream().next();
            }
        }

        @Override
        public void streamClose() {
            assert (Transports.assertTransportThread());
            if (!this.shortCircuited) {
                this.shortCircuit();
            }
        }

        private void shortCircuit() {
            this.shortCircuited = true;
            Releasables.close((Releasable)this.handler);
            Releasables.close(this.unParsedChunks);
            this.unParsedChunks.clear();
        }

        private ArrayList<Releasable> accountParsing(int bytesConsumed) {
            ArrayList<Releasable> releasables = new ArrayList<Releasable>(this.unParsedChunks.size());
            while (bytesConsumed > 0) {
                ReleasableBytesReference reference = this.unParsedChunks.removeFirst();
                releasables.add(reference);
                if (bytesConsumed >= reference.length()) {
                    bytesConsumed -= reference.length();
                    continue;
                }
                this.unParsedChunks.addFirst(reference.retainedSlice(bytesConsumed, reference.length() - bytesConsumed));
                bytesConsumed = 0;
            }
            return releasables;
        }
    }
}

