/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.blockloader.docvalues;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.blockloader.docvalues.BlockDocValuesReader;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.index.mapper.vectors.VectorEncoderDecoder;

public class DenseVectorFromBinaryBlockLoader
extends BlockDocValuesReader.DocValuesBlockLoader {
    private final String fieldName;
    private final int dims;
    private final IndexVersion indexVersion;
    private final DenseVectorFieldMapper.ElementType elementType;

    public DenseVectorFromBinaryBlockLoader(String fieldName, int dims, IndexVersion indexVersion, DenseVectorFieldMapper.ElementType elementType) {
        this.fieldName = fieldName;
        this.dims = dims;
        this.indexVersion = indexVersion;
        this.elementType = elementType;
    }

    @Override
    public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
        return factory.denseVectors(expectedCount, this.dims);
    }

    @Override
    public BlockLoader.AllReader reader(LeafReaderContext context) throws IOException {
        BinaryDocValues docValues = context.reader().getBinaryDocValues(this.fieldName);
        if (docValues == null) {
            return new BlockLoader.ConstantNullsReader();
        }
        return switch (this.elementType) {
            default -> throw new MatchException(null, null);
            case DenseVectorFieldMapper.ElementType.FLOAT -> new FloatDenseVectorFromBinary(docValues, this.dims, this.indexVersion);
            case DenseVectorFieldMapper.ElementType.BYTE -> new ByteDenseVectorFromBinary(docValues, this.dims, this.indexVersion);
            case DenseVectorFieldMapper.ElementType.BIT -> new BitDenseVectorFromBinary(docValues, this.dims, this.indexVersion);
        };
    }

    private static class FloatDenseVectorFromBinary
    extends AbstractDenseVectorFromBinary<float[]> {
        FloatDenseVectorFromBinary(BinaryDocValues docValues, int dims, IndexVersion indexVersion) {
            super(docValues, dims, indexVersion, new float[dims]);
        }

        @Override
        protected void writeScratchToBuilder(float[] scratch, BlockLoader.FloatBuilder builder) {
            for (float value : scratch) {
                builder.appendFloat(value);
            }
        }

        @Override
        protected void decodeDenseVector(BytesRef bytesRef, float[] scratch) {
            VectorEncoderDecoder.decodeDenseVector(this.indexVersion, bytesRef, scratch);
        }

        @Override
        public String toString() {
            return "FloatDenseVectorFromBinary.Bytes";
        }
    }

    private static class ByteDenseVectorFromBinary
    extends AbstractDenseVectorFromBinary<byte[]> {
        ByteDenseVectorFromBinary(BinaryDocValues docValues, int dims, IndexVersion indexVersion) {
            this(docValues, dims, indexVersion, dims);
        }

        protected ByteDenseVectorFromBinary(BinaryDocValues docValues, int dims, IndexVersion indexVersion, int readScratchSize) {
            super(docValues, dims, indexVersion, new byte[readScratchSize]);
        }

        @Override
        public String toString() {
            return "ByteDenseVectorFromBinary.Bytes";
        }

        @Override
        protected void writeScratchToBuilder(byte[] scratch, BlockLoader.FloatBuilder builder) {
            for (byte value : scratch) {
                builder.appendFloat(value);
            }
        }

        @Override
        protected void decodeDenseVector(BytesRef bytesRef, byte[] scratch) {
            VectorEncoderDecoder.decodeDenseVector(this.indexVersion, bytesRef, scratch);
        }
    }

    private static class BitDenseVectorFromBinary
    extends ByteDenseVectorFromBinary {
        BitDenseVectorFromBinary(BinaryDocValues docValues, int dims, IndexVersion indexVersion) {
            super(docValues, dims, indexVersion, dims / 8);
        }

        @Override
        public String toString() {
            return "BitDenseVectorFromBinary.Bytes";
        }
    }

    private static abstract class AbstractDenseVectorFromBinary<T>
    extends BlockDocValuesReader {
        protected final BinaryDocValues docValues;
        protected final IndexVersion indexVersion;
        protected final int dimensions;
        protected final T scratch;

        AbstractDenseVectorFromBinary(BinaryDocValues docValues, int dims, IndexVersion indexVersion, T scratch) {
            this.docValues = docValues;
            this.indexVersion = indexVersion;
            this.dimensions = dims;
            this.scratch = scratch;
        }

        @Override
        public int docId() {
            return this.docValues.docID();
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            this.read(docId, (BlockLoader.FloatBuilder)builder);
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
            try (BlockLoader.FloatBuilder builder = factory.denseVectors(docs.count() - offset, this.dimensions);){
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    this.read(doc, builder);
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        private void read(int doc, BlockLoader.FloatBuilder builder) throws IOException {
            if (!this.docValues.advanceExact(doc)) {
                builder.appendNull();
                return;
            }
            BytesRef bytesRef = this.docValues.binaryValue();
            assert (bytesRef.length > 0);
            this.decodeDenseVector(bytesRef, this.scratch);
            builder.beginPositionEntry();
            this.writeScratchToBuilder(this.scratch, builder);
            builder.endPositionEntry();
        }

        protected abstract void decodeDenseVector(BytesRef var1, T var2);

        protected abstract void writeScratchToBuilder(T var1, BlockLoader.FloatBuilder var2);
    }
}

