/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Objects;

public final class IndexType {
    public static final IndexType NONE = new IndexType(false, false, false, false, false, false);
    private final boolean hasTerms;
    private final boolean hasPoints;
    private final boolean hasPointsMetadata;
    private final boolean hasVectors;
    private final boolean hasDocValues;
    private final boolean hasDocValuesSkipper;

    private IndexType(boolean hasTerms, boolean hasPoints, boolean hasPointsMetadata, boolean hasVectors, boolean hasDocValues, boolean hasDocValuesSkipper) {
        this.hasTerms = hasTerms;
        this.hasPoints = hasPoints;
        this.hasPointsMetadata = hasPointsMetadata;
        this.hasVectors = hasVectors;
        this.hasDocValues = hasDocValues;
        this.hasDocValuesSkipper = hasDocValuesSkipper;
    }

    public boolean hasPoints() {
        return this.hasPoints;
    }

    public boolean hasPointsMetadata() {
        return this.hasPointsMetadata;
    }

    public boolean hasTerms() {
        return this.hasTerms;
    }

    public boolean hasVectors() {
        return this.hasVectors;
    }

    public boolean hasDocValues() {
        return this.hasDocValues;
    }

    public boolean hasDocValuesSkipper() {
        return this.hasDocValuesSkipper;
    }

    public boolean hasOnlyDocValues() {
        return this.hasDocValues && !this.hasDenseIndex();
    }

    public boolean hasDenseIndex() {
        return this.hasPoints || this.hasTerms || this.hasVectors;
    }

    public boolean supportsSortShortcuts() {
        return this.hasTerms || this.hasPoints;
    }

    public static IndexType terms(boolean isIndexed, boolean hasDocValues) {
        if (!isIndexed && !hasDocValues) {
            return NONE;
        }
        return new IndexType(isIndexed, false, false, false, hasDocValues, false);
    }

    public static IndexType skippers() {
        return new IndexType(false, false, false, false, true, true);
    }

    public static IndexType points(boolean isIndexed, boolean hasDocValues) {
        if (!isIndexed && !hasDocValues) {
            return NONE;
        }
        return new IndexType(false, isIndexed, isIndexed, false, hasDocValues, false);
    }

    public static IndexType archivedPoints() {
        return new IndexType(false, false, true, false, true, false);
    }

    public static IndexType docValuesOnly() {
        return new IndexType(false, false, false, false, true, false);
    }

    public static IndexType vectors() {
        return new IndexType(false, false, false, true, false, false);
    }

    public String toString() {
        return "IndexType{hasTerms=" + this.hasTerms + ", hasPoints=" + this.hasPoints + ", hasPointsMetadata=" + this.hasPointsMetadata + ", hasVectors=" + this.hasVectors + ", hasDocValues=" + this.hasDocValues + ", hasDocValuesSkipper=" + this.hasDocValuesSkipper + "}";
    }

    public boolean equals(Object o) {
        if (o instanceof IndexType) {
            IndexType indexType = (IndexType)o;
            return this.hasTerms == indexType.hasTerms && this.hasPoints == indexType.hasPoints && this.hasPointsMetadata == indexType.hasPointsMetadata && this.hasVectors == indexType.hasVectors && this.hasDocValues == indexType.hasDocValues && this.hasDocValuesSkipper == indexType.hasDocValuesSkipper;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.hasTerms, this.hasPoints, this.hasPointsMetadata, this.hasVectors, this.hasDocValues, this.hasDocValuesSkipper);
    }
}

