/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.ByteUtils;
import org.elasticsearch.common.util.FeatureFlag;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.LuceneDocument;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.RootObjectMapper;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.StoredValueFetcher;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.mapper.XContentDataHelper;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.lookup.SourceFilter;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public class IgnoredSourceFieldMapper
extends MetadataFieldMapper {
    private final IndexSettings indexSettings;
    private static final int PARENT_OFFSET_IN_NAME_OFFSET = 65536;
    public static final String NAME = "_ignored_source";
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.FixedTypeParser(context -> new IgnoredSourceFieldMapper(context.getIndexSettings()));
    static final NodeFeature DONT_EXPAND_DOTS_IN_IGNORED_SOURCE = new NodeFeature("mapper.ignored_source.dont_expand_dots");
    static final NodeFeature IGNORED_SOURCE_AS_TOP_LEVEL_METADATA_ARRAY_FIELD = new NodeFeature("mapper.ignored_source_as_top_level_metadata_array_field");
    static final NodeFeature ALWAYS_STORE_OBJECT_ARRAYS_IN_NESTED_OBJECTS = new NodeFeature("mapper.ignored_source.always_store_object_arrays_in_nested");
    public static final FeatureFlag COALESCE_IGNORED_SOURCE_ENTRIES = new FeatureFlag("ignored_source_fields_per_entry");
    public static final Setting<Boolean> SKIP_IGNORED_SOURCE_WRITE_SETTING = Setting.boolSetting("index.mapping.synthetic_source.skip_ignored_source_write", false, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Boolean> SKIP_IGNORED_SOURCE_READ_SETTING = Setting.boolSetting("index.mapping.synthetic_source.skip_ignored_source_read", false, Setting.Property.Dynamic, Setting.Property.IndexScope);

    private IgnoredSourceFieldMapper(IndexSettings indexSettings) {
        super(IgnoredValuesFieldMapperType.INSTANCE);
        this.indexSettings = indexSettings;
    }

    @Override
    protected String contentType() {
        return NAME;
    }

    @Override
    public void postParse(DocumentParserContext context) {
        if (!context.mappingLookup().isSourceSynthetic()) {
            assert (context.getIgnoredFieldValues().isEmpty());
            return;
        }
        IgnoredSourceFieldMapper.ignoredSourceFormat(context.indexSettings().getIndexVersionCreated()).writeIgnoredFields(context.getIgnoredFieldValues());
    }

    public static Set<String> ensureLoaded(Set<String> fieldsToLoadForSyntheticSource, IndexSettings indexSettings) {
        if (!indexSettings.getSkipIgnoredSourceRead()) {
            fieldsToLoadForSyntheticSource.add(NAME);
        }
        return fieldsToLoadForSyntheticSource;
    }

    public IgnoredSourceFormat ignoredSourceFormat() {
        return IgnoredSourceFieldMapper.ignoredSourceFormat(this.indexSettings.getIndexVersionCreated());
    }

    public static IgnoredSourceFormat ignoredSourceFormat(IndexVersion indexCreatedVersion) {
        IndexVersion switchToNewFormatVersion = COALESCE_IGNORED_SOURCE_ENTRIES.isEnabled() ? IndexVersions.IGNORED_SOURCE_COALESCED_ENTRIES_WITH_FF : IndexVersions.IGNORED_SOURCE_COALESCED_ENTRIES;
        return indexCreatedVersion.onOrAfter(switchToNewFormatVersion) ? IgnoredSourceFormat.COALESCED_SINGLE_IGNORED_SOURCE : IgnoredSourceFormat.LEGACY_SINGLE_IGNORED_SOURCE;
    }

    @Override
    protected FieldMapper.SyntheticSourceSupport syntheticSourceSupport() {
        return new FieldMapper.SyntheticSourceSupport.Native(() -> new SourceLoader.SyntheticFieldLoader(){

            @Override
            public Stream<Map.Entry<String, SourceLoader.SyntheticFieldLoader.StoredFieldLoader>> storedFieldLoaders() {
                if (IgnoredSourceFieldMapper.this.indexSettings.getSkipIgnoredSourceRead()) {
                    return Stream.empty();
                }
                return Stream.of(Map.entry(IgnoredSourceFieldMapper.NAME, v -> {}));
            }

            @Override
            public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader leafReader, int[] docIdsInLeaf) throws IOException {
                return null;
            }

            @Override
            public boolean hasValue() {
                return false;
            }

            @Override
            public void write(XContentBuilder b) throws IOException {
            }

            @Override
            public String fieldName() {
                return IgnoredSourceFieldMapper.NAME;
            }

            @Override
            public void reset() {
            }
        });
    }

    private static MappedNameValue nameValueToMapped(NameValue nameValue) throws IOException {
        XContentBuilder xContentBuilder = XContentBuilder.builder((XContent)XContentDataHelper.getXContentType(nameValue.value()).xContent());
        xContentBuilder.startObject().field(nameValue.name());
        XContentDataHelper.decodeAndWrite(xContentBuilder, nameValue.value());
        xContentBuilder.endObject();
        Tuple<XContentType, Map<String, Object>> result = XContentHelper.convertToMap(BytesReference.bytes(xContentBuilder), true);
        return new MappedNameValue(nameValue, (XContentType)result.v1(), (Map)result.v2());
    }

    private static NameValue mappedToNameValue(MappedNameValue mappedNameValue) throws IOException {
        XContentBuilder xContentBuilder;
        assert (mappedNameValue.map.size() == 1);
        Object content = mappedNameValue.map.values().iterator().next();
        if (content instanceof Map) {
            Map objectMap = (Map)content;
            xContentBuilder = XContentBuilder.builder((XContent)mappedNameValue.type().xContent()).map(objectMap);
        } else {
            xContentBuilder = XContentBuilder.builder((XContent)mappedNameValue.type().xContent()).value(content);
        }
        XContentBuilder xContentBuilder2 = xContentBuilder;
        NameValue oldNameValue = mappedNameValue.nameValue();
        return new NameValue(oldNameValue.name(), oldNameValue.parentOffset(), XContentDataHelper.encodeXContentBuilder(xContentBuilder2), oldNameValue.doc());
    }

    static final class IgnoredValuesFieldMapperType
    extends StringFieldType {
        private static final IgnoredValuesFieldMapperType INSTANCE = new IgnoredValuesFieldMapperType();

        private IgnoredValuesFieldMapperType() {
            super(IgnoredSourceFieldMapper.NAME, false, true, false, TextSearchInfo.NONE, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return IgnoredSourceFieldMapper.NAME;
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return new StoredValueFetcher(context.lookup(), IgnoredSourceFieldMapper.NAME);
        }
    }

    public static enum IgnoredSourceFormat {
        NO_IGNORED_SOURCE{

            @Override
            public Map<String, List<NameValue>> loadAllIgnoredFields(SourceFilter filter, Map<String, List<Object>> storedFields) {
                return Map.of();
            }

            @Override
            public Map<String, List<NameValue>> loadSingleIgnoredField(Set<String> fieldPaths, Map<String, List<Object>> storedFields) {
                return Map.of();
            }

            @Override
            public void writeIgnoredFields(Collection<NameValue> ignoredFieldValues) {
                assert (false) : "cannot write " + ignoredFieldValues.size() + " values with format NO_IGNORED_SOURCE";
            }

            @Override
            public BytesRef filterValue(BytesRef value, Function<Map<String, Object>, Map<String, Object>> filter) {
                assert (false) : "cannot filter ignored source with format NO_IGNORED_SOURCE";
                return null;
            }
        }
        ,
        LEGACY_SINGLE_IGNORED_SOURCE{

            @Override
            public Map<String, List<NameValue>> loadAllIgnoredFields(SourceFilter filter, Map<String, List<Object>> storedFields) {
                HashMap<String, List> objectsWithIgnoredFields = null;
                List<Object> storedValues = storedFields.get(IgnoredSourceFieldMapper.NAME);
                if (storedValues != null) {
                    for (Object value : storedValues) {
                        if (objectsWithIgnoredFields == null) {
                            objectsWithIgnoredFields = new HashMap<String, List>();
                        }
                        NameValue nameValue = LegacyIgnoredSourceEncoding.decode(value);
                        if (filter != null && filter.isPathFiltered(nameValue.name(), XContentDataHelper.isEncodedObject(nameValue.value()))) continue;
                        objectsWithIgnoredFields.computeIfAbsent(nameValue.getParentFieldName(), k -> new ArrayList()).add(nameValue);
                    }
                }
                return objectsWithIgnoredFields;
            }

            @Override
            public Map<String, List<NameValue>> loadSingleIgnoredField(Set<String> fieldPaths, Map<String, List<Object>> storedFields) {
                HashMap<String, List<NameValue>> valuesForFieldAndParents = new HashMap<String, List<NameValue>>();
                List<Object> ignoredSource = storedFields.get(IgnoredSourceFieldMapper.NAME);
                if (ignoredSource != null) {
                    for (Object value : ignoredSource) {
                        NameValue nameValue = LegacyIgnoredSourceEncoding.decode(value);
                        if (!fieldPaths.contains(nameValue.name())) continue;
                        valuesForFieldAndParents.computeIfAbsent(nameValue.name(), k -> new ArrayList()).add(nameValue);
                    }
                }
                return valuesForFieldAndParents;
            }

            @Override
            public void writeIgnoredFields(Collection<NameValue> ignoredFieldValues) {
                for (NameValue nameValue : ignoredFieldValues) {
                    nameValue.doc().add((IndexableField)new StoredField(IgnoredSourceFieldMapper.NAME, LegacyIgnoredSourceEncoding.encode(nameValue)));
                }
            }

            @Override
            public BytesRef filterValue(BytesRef value, Function<Map<String, Object>, Map<String, Object>> filter) throws IOException {
                MappedNameValue mappedNameValue = LegacyIgnoredSourceEncoding.decodeAsMap(value);
                Map<String, Object> transformedField = filter.apply(mappedNameValue.map());
                if (transformedField.isEmpty()) {
                    return null;
                }
                Object topValue = mappedNameValue.map().values().iterator().next();
                if (topValue instanceof Map || topValue instanceof List) {
                    return LegacyIgnoredSourceEncoding.encodeFromMap(mappedNameValue.withMap(transformedField));
                }
                return value;
            }
        }
        ,
        COALESCED_SINGLE_IGNORED_SOURCE{

            @Override
            public Map<String, List<NameValue>> loadAllIgnoredFields(SourceFilter filter, Map<String, List<Object>> storedFields) {
                HashMap<String, List> objectsWithIgnoredFields = null;
                List<Object> ignoredSource = storedFields.get(IgnoredSourceFieldMapper.NAME);
                if (ignoredSource == null) {
                    return objectsWithIgnoredFields;
                }
                for (Object ignoredSourceEntry : ignoredSource) {
                    List<NameValue> nameValues;
                    if (objectsWithIgnoredFields == null) {
                        objectsWithIgnoredFields = new HashMap<String, List>();
                    }
                    List<NameValue> list = nameValues = ignoredSourceEntry instanceof List ? (List<NameValue>)ignoredSourceEntry : CoalescedIgnoredSourceEncoding.decode((BytesRef)ignoredSourceEntry);
                    assert (!nameValues.isEmpty());
                    for (NameValue nameValue : nameValues) {
                        if (filter != null && filter.isPathFiltered(nameValue.name(), XContentDataHelper.isEncodedObject(nameValue.value()))) continue;
                        objectsWithIgnoredFields.computeIfAbsent(nameValue.getParentFieldName(), k -> new ArrayList()).add(nameValue);
                    }
                }
                return objectsWithIgnoredFields;
            }

            @Override
            public Map<String, List<NameValue>> loadSingleIgnoredField(Set<String> fieldPaths, Map<String, List<Object>> storedFields) {
                HashMap<String, List<NameValue>> valuesForFieldAndParents = new HashMap<String, List<NameValue>>();
                List<Object> ignoredSource = storedFields.get(IgnoredSourceFieldMapper.NAME);
                if (ignoredSource == null) {
                    return valuesForFieldAndParents;
                }
                for (Object ignoredSourceEntry : ignoredSource) {
                    List<NameValue> nameValues;
                    List<NameValue> list = nameValues = ignoredSourceEntry instanceof List ? (List<NameValue>)ignoredSourceEntry : CoalescedIgnoredSourceEncoding.decode((BytesRef)ignoredSourceEntry);
                    assert (!nameValues.isEmpty());
                    String fieldPath = nameValues.getFirst().name();
                    if (!fieldPaths.contains(fieldPath)) continue;
                    assert (!valuesForFieldAndParents.containsKey(fieldPath));
                    valuesForFieldAndParents.put(fieldPath, nameValues);
                }
                return valuesForFieldAndParents;
            }

            @Override
            public void writeIgnoredFields(Collection<NameValue> ignoredFieldValues) {
                HashMap<LuceneDocument, Map> entriesMap = new HashMap<LuceneDocument, Map>();
                for (NameValue nameValue : ignoredFieldValues) {
                    entriesMap.computeIfAbsent(nameValue.doc(), d -> new HashMap()).computeIfAbsent(nameValue.name(), n -> new ArrayList()).add(nameValue);
                }
                for (Map.Entry entry : entriesMap.entrySet()) {
                    for (Map.Entry fieldEntry : ((Map)entry.getValue()).entrySet()) {
                        ((LuceneDocument)entry.getKey()).add((IndexableField)new StoredField(IgnoredSourceFieldMapper.NAME, CoalescedIgnoredSourceEncoding.encode((List)fieldEntry.getValue())));
                    }
                }
            }

            @Override
            public BytesRef filterValue(BytesRef value, Function<Map<String, Object>, Map<String, Object>> filter) throws IOException {
                List<MappedNameValue> mappedNameValues = CoalescedIgnoredSourceEncoding.decodeAsMap(value);
                ArrayList<MappedNameValue> filteredNameValues = new ArrayList<MappedNameValue>(mappedNameValues.size());
                boolean maybeDidFilter = false;
                for (MappedNameValue mappedNameValue : mappedNameValues) {
                    Map<String, Object> transformedField = filter.apply(mappedNameValue.map());
                    if (transformedField.isEmpty()) {
                        maybeDidFilter = true;
                        continue;
                    }
                    Object topValue = mappedNameValue.map().values().iterator().next();
                    if (topValue instanceof Map || topValue instanceof List) {
                        maybeDidFilter = true;
                    }
                    filteredNameValues.add(mappedNameValue.withMap(transformedField));
                }
                if (maybeDidFilter) {
                    if (filteredNameValues.isEmpty()) {
                        return null;
                    }
                    return CoalescedIgnoredSourceEncoding.encodeFromMap(filteredNameValues);
                }
                return value;
            }
        };


        public abstract Map<String, List<NameValue>> loadAllIgnoredFields(SourceFilter var1, Map<String, List<Object>> var2);

        public abstract Map<String, List<NameValue>> loadSingleIgnoredField(Set<String> var1, Map<String, List<Object>> var2);

        public abstract void writeIgnoredFields(Collection<NameValue> var1);

        public abstract BytesRef filterValue(BytesRef var1, Function<Map<String, Object>, Map<String, Object>> var2) throws IOException;
    }

    public record NameValue(String name, int parentOffset, BytesRef value, LuceneDocument doc) {
        public static NameValue fromContext(DocumentParserContext context, String name, BytesRef value) {
            int parentOffset = context.parent() instanceof RootObjectMapper ? 0 : context.parent().fullPath().length() + 1;
            return new NameValue(name, parentOffset, value, context.doc());
        }

        String getParentFieldName() {
            return this.parentOffset == 0 ? "_doc" : this.name.substring(0, this.parentOffset - 1);
        }

        String getFieldName() {
            return this.parentOffset() == 0 ? this.name() : this.name().substring(this.parentOffset());
        }

        NameValue cloneWithValue(BytesRef value) {
            assert (this.value() == null);
            return new NameValue(this.name, this.parentOffset, value, this.doc);
        }

        boolean hasValue() {
            return XContentDataHelper.isDataPresent(this.value);
        }
    }

    public record MappedNameValue(NameValue nameValue, XContentType type, Map<String, Object> map) {
        public MappedNameValue withMap(Map<String, Object> map) {
            return new MappedNameValue(new NameValue(this.nameValue.name, this.nameValue.parentOffset, null, this.nameValue.doc), this.type, map);
        }
    }

    public static class CoalescedIgnoredSourceEncoding {
        public static BytesRef encode(List<NameValue> values) {
            assert (!values.isEmpty());
            try {
                BytesStreamOutput stream = new BytesStreamOutput();
                stream.writeVInt(values.size());
                String fieldName = values.getFirst().name;
                stream.writeString(fieldName);
                for (NameValue value : values) {
                    assert (fieldName.equals(value.name));
                    stream.writeVInt(value.parentOffset);
                    stream.writeBytesRef(value.value);
                }
                return stream.bytes().toBytesRef();
            }
            catch (IOException e) {
                throw new ElasticsearchException("Failed to encode _ignored_source", (Throwable)e, new Object[0]);
            }
        }

        public static List<NameValue> decode(BytesRef value) {
            try {
                StreamInput stream = new BytesArray(value).streamInput();
                int count = stream.readVInt();
                assert (count >= 1);
                String fieldName = stream.readString();
                ArrayList<NameValue> values = new ArrayList<NameValue>(count);
                for (int i = 0; i < count; ++i) {
                    int parentOffset = stream.readVInt();
                    BytesRef valueBytes = stream.readBytesRef();
                    values.add(new NameValue(fieldName, parentOffset, valueBytes, null));
                }
                return values;
            }
            catch (IOException e) {
                throw new ElasticsearchException("Failed to decode _ignored_source", (Throwable)e, new Object[0]);
            }
        }

        public static BytesRef encodeFromMap(List<MappedNameValue> filteredValues) throws IOException {
            ArrayList<NameValue> filteredNameValues = new ArrayList<NameValue>(filteredValues.size());
            for (MappedNameValue filteredValue : filteredValues) {
                filteredNameValues.add(IgnoredSourceFieldMapper.mappedToNameValue(filteredValue));
            }
            return CoalescedIgnoredSourceEncoding.encode(filteredNameValues);
        }

        public static List<MappedNameValue> decodeAsMap(BytesRef value) throws IOException {
            List<NameValue> nameValues = CoalescedIgnoredSourceEncoding.decode(value);
            ArrayList<MappedNameValue> mappedValues = new ArrayList<MappedNameValue>(nameValues.size());
            for (NameValue nameValue : nameValues) {
                mappedValues.add(IgnoredSourceFieldMapper.nameValueToMapped(nameValue));
            }
            return mappedValues;
        }
    }

    public static class LegacyIgnoredSourceEncoding {
        public static BytesRef encode(NameValue values) {
            assert (values.parentOffset < 65536);
            assert ((long)values.parentOffset * 65536L < Integer.MAX_VALUE);
            byte[] nameBytes = values.name.getBytes(StandardCharsets.UTF_8);
            byte[] bytes = new byte[4 + nameBytes.length + values.value.length];
            ByteUtils.writeIntLE(values.name.length() + 65536 * values.parentOffset, bytes, 0);
            System.arraycopy(nameBytes, 0, bytes, 4, nameBytes.length);
            System.arraycopy(values.value.bytes, values.value.offset, bytes, 4 + nameBytes.length, values.value.length);
            return new BytesRef(bytes);
        }

        public static NameValue decode(Object field) {
            byte[] bytes = ((BytesRef)field).bytes;
            int encodedSize = ByteUtils.readIntLE(bytes, 0);
            int nameSize = encodedSize % 65536;
            int parentOffset = encodedSize / 65536;
            String decoded = new String(bytes, 4, bytes.length - 4, StandardCharsets.UTF_8);
            String name = decoded.substring(0, nameSize);
            int nameByteCount = name.getBytes(StandardCharsets.UTF_8).length;
            BytesRef value = new BytesRef(bytes, 4 + nameByteCount, bytes.length - nameByteCount - 4);
            return new NameValue(name, parentOffset, value, null);
        }

        public static BytesRef encodeFromMap(MappedNameValue mappedNameValue) throws IOException {
            return LegacyIgnoredSourceEncoding.encode(IgnoredSourceFieldMapper.mappedToNameValue(mappedNameValue));
        }

        public static MappedNameValue decodeAsMap(BytesRef value) throws IOException {
            return IgnoredSourceFieldMapper.nameValueToMapped(LegacyIgnoredSourceEncoding.decode(value));
        }
    }
}

