/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

public final class ContentPath {
    private static final char DELIMITER = '.';
    private final StringBuilder sb;
    private int index = 0;
    private String[] path = new String[10];
    private boolean withinLeafObject = false;

    public ContentPath() {
        this.sb = new StringBuilder();
    }

    String[] getPath() {
        return this.path;
    }

    public void add(String name) {
        this.path[this.index++] = name;
        if (this.index == this.path.length) {
            this.expand();
        }
    }

    private void expand() {
        String[] newPath = new String[this.path.length + 10];
        System.arraycopy(this.path, 0, newPath, 0, this.path.length);
        this.path = newPath;
    }

    public String remove() {
        String ret = this.path[--this.index];
        this.path[this.index] = null;
        return ret;
    }

    public void setWithinLeafObject(boolean withinLeafObject) {
        this.withinLeafObject = withinLeafObject;
    }

    public boolean isWithinLeafObject() {
        return this.withinLeafObject;
    }

    public String pathAsText(String name) {
        if (this.index == 0) {
            return name;
        }
        this.sb.setLength(0);
        for (int i = 0; i < this.index; ++i) {
            this.sb.append(this.path[i]).append('.');
        }
        this.sb.append(name);
        return this.sb.toString();
    }

    public int length() {
        return this.index;
    }
}

