/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.util.function.LongConsumer;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.InPlaceMergeSorter;
import org.apache.lucene.util.Sorter;
import org.elasticsearch.index.fielddata.SortedNumericLongValues;

public abstract class SortingNumericLongValues
extends SortedNumericLongValues {
    private int count;
    protected long[] values = new long[1];
    protected int valuesCursor = 0;
    private final Sorter sorter = new InPlaceMergeSorter(){

        protected void swap(int i, int j) {
            long tmp = SortingNumericLongValues.this.values[i];
            SortingNumericLongValues.this.values[i] = SortingNumericLongValues.this.values[j];
            SortingNumericLongValues.this.values[j] = tmp;
        }

        protected int compare(int i, int j) {
            return Long.compare(SortingNumericLongValues.this.values[i], SortingNumericLongValues.this.values[j]);
        }
    };
    private final LongConsumer circuitBreakerConsumer;

    protected SortingNumericLongValues() {
        this(l -> {});
    }

    protected SortingNumericLongValues(LongConsumer circuitBreakerConsumer) {
        this.circuitBreakerConsumer = circuitBreakerConsumer;
        this.circuitBreakerConsumer.accept(8L);
    }

    protected final void resize(int newSize) {
        this.count = newSize;
        this.valuesCursor = 0;
        if (newSize <= this.getArrayLength()) {
            return;
        }
        long oldValuesSizeInBytes = (long)this.getArrayLength() * 8L;
        int newValuesLength = ArrayUtil.oversize((int)newSize, (int)8);
        this.circuitBreakerConsumer.accept((long)newValuesLength * 8L);
        this.growExact(newValuesLength);
        this.circuitBreakerConsumer.accept(-oldValuesSizeInBytes);
    }

    protected void growExact(int newValuesLength) {
        this.values = ArrayUtil.growExact((long[])this.values, (int)newValuesLength);
    }

    protected int getArrayLength() {
        return this.values.length;
    }

    protected final void sort() {
        this.sorter.sort(0, this.count);
    }

    @Override
    public final int docValueCount() {
        return this.count;
    }

    @Override
    public final long nextValue() {
        return this.values[this.valuesCursor++];
    }
}

