/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.diskbbq.next;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.hnsw.FlatVectorScorerUtil;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.elasticsearch.index.codec.vectors.DirectIOCapableFlatVectorsFormat;
import org.elasticsearch.index.codec.vectors.diskbbq.next.ESNextDiskBBQVectorsReader;
import org.elasticsearch.index.codec.vectors.diskbbq.next.ESNextDiskBBQVectorsWriter;
import org.elasticsearch.index.codec.vectors.es93.DirectIOCapableLucene99FlatVectorsFormat;
import org.elasticsearch.simdvec.ESVectorUtil;

public class ESNextDiskBBQVectorsFormat
extends KnnVectorsFormat {
    public static final String NAME = "ESNextDiskBBQVectorsFormat";
    public static final int VERSION_START = 1;
    public static final int VERSION_CURRENT = 1;
    private static final DirectIOCapableFlatVectorsFormat rawVectorFormat = new DirectIOCapableLucene99FlatVectorsFormat(FlatVectorScorerUtil.getLucene99FlatVectorsScorer());
    private static final Map<String, DirectIOCapableFlatVectorsFormat> supportedFormats = Map.of(rawVectorFormat.getName(), rawVectorFormat);
    public static final int DEFAULT_VECTORS_PER_CLUSTER = 384;
    public static final int MIN_VECTORS_PER_CLUSTER = 64;
    public static final int MAX_VECTORS_PER_CLUSTER = 65536;
    public static final int DEFAULT_CENTROIDS_PER_PARENT_CLUSTER = 16;
    public static final int MIN_CENTROIDS_PER_PARENT_CLUSTER = 2;
    public static final int MAX_CENTROIDS_PER_PARENT_CLUSTER = 256;
    private final QuantEncoding quantEncoding;
    private final int vectorPerCluster;
    private final int centroidsPerParentCluster;
    private final boolean useDirectIO;

    public ESNextDiskBBQVectorsFormat(int vectorPerCluster, int centroidsPerParentCluster) {
        this(QuantEncoding.ONE_BIT_4BIT_QUERY, vectorPerCluster, centroidsPerParentCluster);
    }

    public ESNextDiskBBQVectorsFormat(QuantEncoding quantEncoding, int vectorPerCluster, int centroidsPerParentCluster) {
        this(quantEncoding, vectorPerCluster, centroidsPerParentCluster, false);
    }

    public ESNextDiskBBQVectorsFormat(QuantEncoding quantEncoding, int vectorPerCluster, int centroidsPerParentCluster, boolean useDirectIO) {
        super(NAME);
        if (vectorPerCluster < 64 || vectorPerCluster > 65536) {
            throw new IllegalArgumentException("vectorsPerCluster must be between 64 and 65536, got: " + vectorPerCluster);
        }
        if (centroidsPerParentCluster < 2 || centroidsPerParentCluster > 256) {
            throw new IllegalArgumentException("centroidsPerParentCluster must be between 2 and 256, got: " + centroidsPerParentCluster);
        }
        this.vectorPerCluster = vectorPerCluster;
        this.centroidsPerParentCluster = centroidsPerParentCluster;
        this.quantEncoding = quantEncoding;
        this.useDirectIO = useDirectIO;
    }

    public ESNextDiskBBQVectorsFormat() {
        this(384, 16);
    }

    public KnnVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return new ESNextDiskBBQVectorsWriter(state, rawVectorFormat.getName(), this.useDirectIO, rawVectorFormat.fieldsWriter(state), this.quantEncoding, this.vectorPerCluster, this.centroidsPerParentCluster);
    }

    public KnnVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        return new ESNextDiskBBQVectorsReader(state, (f, dio) -> {
            DirectIOCapableFlatVectorsFormat format = supportedFormats.get(f);
            if (format == null) {
                return null;
            }
            return format.fieldsReader(state, dio);
        });
    }

    public int getMaxDimensions(String fieldName) {
        return 4096;
    }

    public String toString() {
        return "ESNextDiskBBQVectorsFormat(vectorPerCluster=" + this.vectorPerCluster + ")";
    }

    public static abstract sealed class QuantEncoding
    extends Enum<QuantEncoding> {
        public static final /* enum */ QuantEncoding ONE_BIT_4BIT_QUERY = new QuantEncoding(0, 1, 4){

            @Override
            public void pack(int[] quantized, byte[] destination) {
                ESVectorUtil.packAsBinary((int[])quantized, (byte[])destination);
            }

            @Override
            public void packQuery(int[] quantized, byte[] destination) {
                ESVectorUtil.transposeHalfByte((int[])quantized, (byte[])destination);
            }
        };
        private final int id;
        private final byte bits;
        private final byte queryBits;
        private static final /* synthetic */ QuantEncoding[] $VALUES;

        public static QuantEncoding[] values() {
            return (QuantEncoding[])$VALUES.clone();
        }

        public static QuantEncoding valueOf(String name) {
            return Enum.valueOf(QuantEncoding.class, name);
        }

        private QuantEncoding(int id, byte bits, byte queryBits) {
            this.id = id;
            this.bits = bits;
            this.queryBits = queryBits;
        }

        public abstract void pack(int[] var1, byte[] var2);

        public abstract void packQuery(int[] var1, byte[] var2);

        public int id() {
            return this.id;
        }

        public byte bits() {
            return this.bits;
        }

        public byte queryBits() {
            return this.queryBits;
        }

        public int discretizedDimensions(int dimensions) {
            if (this.queryBits == this.bits) {
                int totalBits = dimensions * this.bits;
                return (totalBits + 7) / 8 * 8 / this.bits;
            }
            int queryDiscretized = (dimensions * this.queryBits + 7) / 8 * 8 / this.queryBits;
            int docDiscretized = (dimensions * this.bits + 7) / 8 * 8 / this.bits;
            int maxDiscretized = Math.max(queryDiscretized, docDiscretized);
            assert ((double)maxDiscretized % (8.0 / (double)this.queryBits) == 0.0) : "bad discretized=" + maxDiscretized + " for dim=" + dimensions;
            assert ((double)maxDiscretized % (8.0 / (double)this.bits) == 0.0) : "bad discretized=" + maxDiscretized + " for dim=" + dimensions;
            return maxDiscretized;
        }

        public int getDocPackedLength(int dimensions) {
            int discretized = this.discretizedDimensions(dimensions);
            int totalBits = discretized * this.bits;
            return (totalBits + 7) / 8;
        }

        public int getQueryPackedLength(int dimensions) {
            int discretized = this.discretizedDimensions(dimensions);
            int totalBits = discretized * this.queryBits;
            return (totalBits + 7) / 8;
        }

        public static QuantEncoding fromId(int id) {
            for (QuantEncoding encoding : QuantEncoding.values()) {
                if (encoding.id != id) continue;
                return encoding;
            }
            throw new IllegalArgumentException("Unknown QuantEncoding id: " + id);
        }

        private static /* synthetic */ QuantEncoding[] $values() {
            return new QuantEncoding[]{ONE_BIT_4BIT_QUERY};
        }

        static {
            $VALUES = QuantEncoding.$values();
        }
    }
}

