/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.tsdb;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.index.BaseTermsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.index.mapper.TimeSeriesRoutingHashFieldMapper;
import org.elasticsearch.index.mapper.TsidExtractingIdFieldMapper;
import org.elasticsearch.index.mapper.Uid;

public class TSDBSyntheticIdFieldsProducer
extends FieldsProducer {
    private static final Set<String> FIELDS_NAMES = Set.of("_id");
    private final DocValuesProducer docValuesProducer;
    private final FieldInfos fieldInfos;
    private final int maxDocs;

    public TSDBSyntheticIdFieldsProducer(SegmentReadState state, DocValuesProducer docValuesProducer) {
        this(state.fieldInfos, docValuesProducer, state.segmentInfo.maxDoc());
    }

    private TSDBSyntheticIdFieldsProducer(FieldInfos fieldInfos, DocValuesProducer docValuesProducer, int maxDocs) {
        assert (TSDBSyntheticIdFieldsProducer.assertFieldInfosExist(fieldInfos, "_id", "@timestamp", "_tsid"));
        this.docValuesProducer = Objects.requireNonNull(docValuesProducer);
        this.fieldInfos = fieldInfos;
        this.maxDocs = maxDocs;
    }

    public int size() {
        return FIELDS_NAMES.size();
    }

    public Iterator<String> iterator() {
        return FIELDS_NAMES.iterator();
    }

    public void close() throws IOException {
        IOUtils.close((Closeable)this.docValuesProducer);
    }

    public void checkIntegrity() throws IOException {
    }

    public FieldsProducer getMergeInstance() {
        return new TSDBSyntheticIdFieldsProducer(this.fieldInfos, this.docValuesProducer, this.maxDocs);
    }

    public Terms terms(String field) throws IOException {
        assert (FIELDS_NAMES.contains(field)) : field;
        return new Terms(){

            public TermsEnum iterator() {
                return new FakeTermsEnum();
            }

            public int getDocCount() {
                return TSDBSyntheticIdFieldsProducer.this.maxDocs - 1;
            }

            public long size() {
                return -1L;
            }

            public long getSumTotalTermFreq() {
                return 0L;
            }

            public long getSumDocFreq() {
                return 0L;
            }

            public boolean hasFreqs() {
                return false;
            }

            public boolean hasOffsets() {
                return false;
            }

            public boolean hasPositions() {
                return false;
            }

            public boolean hasPayloads() {
                return false;
            }
        };
    }

    private static boolean assertFieldInfosExist(FieldInfos fieldInfos, String ... fieldNames) {
        assert (fieldNames != null && fieldNames.length > 0) : "fieldNames should be > 0";
        for (String fieldName : fieldNames) {
            assert (fieldInfos.fieldInfo(fieldName) != null) : "field [" + fieldName + "] not found";
        }
        return true;
    }

    private static UnsupportedOperationException unsupportedException() {
        String error = "This method should not be called on this enum";
        assert (false) : error;
        return new UnsupportedOperationException(error);
    }

    private class FakePostingsEnum
    extends PostingsEnum {
        private final int startDocID;
        private final BytesRef latestTsId;
        private final long latestTimestamp;
        private final int maxDocs;
        private int docID;

        private FakePostingsEnum(int docID, BytesRef latestTsId, long latestTimestamp, int maxDocs) {
            this.startDocID = docID;
            this.latestTsId = latestTsId;
            this.latestTimestamp = latestTimestamp;
            this.maxDocs = maxDocs;
            this.docID = -1;
        }

        public int docID() {
            return this.docID;
        }

        public int nextDoc() throws IOException {
            if (this.docID == Integer.MAX_VALUE) {
                return this.docID;
            }
            if (this.docID == -1) {
                this.docID = this.startDocID;
            } else {
                ++this.docID;
                if (this.maxDocs <= this.docID) {
                    this.docID = Integer.MAX_VALUE;
                    return this.docID;
                }
            }
            SortedDocValues tsIdDocValues = TSDBSyntheticIdFieldsProducer.this.docValuesProducer.getSorted(TSDBSyntheticIdFieldsProducer.this.fieldInfos.fieldInfo("_tsid"));
            boolean found = tsIdDocValues.advanceExact(this.docID);
            assert (found);
            int tsIdOrd = tsIdDocValues.ordValue();
            BytesRef tsId = tsIdDocValues.lookupOrd(tsIdOrd);
            assert (tsId != null);
            if (this.latestTsId != null && !this.latestTsId.equals((Object)tsId)) {
                this.docID = Integer.MAX_VALUE;
                return this.docID;
            }
            SortedNumericDocValues timestampDocValues = TSDBSyntheticIdFieldsProducer.this.docValuesProducer.getSortedNumeric(TSDBSyntheticIdFieldsProducer.this.fieldInfos.fieldInfo("@timestamp"));
            found = timestampDocValues.advanceExact(this.docID);
            assert (found);
            assert (timestampDocValues.docValueCount() == 1);
            long timestamp = timestampDocValues.nextValue();
            if (this.latestTimestamp != -1L && this.latestTimestamp != timestamp) {
                this.docID = Integer.MAX_VALUE;
                return this.docID;
            }
            FieldInfo tsRoutingHash = TSDBSyntheticIdFieldsProducer.this.fieldInfos.fieldInfo("_ts_routing_hash");
            assert (tsRoutingHash != null);
            SortedDocValues routingHashDocValues = TSDBSyntheticIdFieldsProducer.this.docValuesProducer.getSorted(tsRoutingHash);
            found = routingHashDocValues.advanceExact(this.docID);
            assert (found);
            BytesRef routingHashBytes = routingHashDocValues.lookupOrd(routingHashDocValues.ordValue());
            assert (routingHashBytes != null);
            return this.docID;
        }

        public int advance(int target) throws IOException {
            int doc;
            while ((doc = this.nextDoc()) < target) {
            }
            return doc;
        }

        public long cost() {
            return 0L;
        }

        public int freq() throws IOException {
            return 0;
        }

        public int nextPosition() throws IOException {
            return -1;
        }

        public int startOffset() throws IOException {
            return -1;
        }

        public int endOffset() throws IOException {
            return -1;
        }

        public BytesRef getPayload() throws IOException {
            return null;
        }
    }

    private class FakeTermsEnum
    extends BaseTermsEnum {
        private BytesRef term = null;
        private int docID = -1;
        private BytesRef latestTsId = null;
        private long latestTimestamp = -1L;

        private FakeTermsEnum() {
        }

        public BytesRef next() throws IOException {
            if (this.docID == Integer.MAX_VALUE) {
                assert (this.term == null);
                return null;
            }
            ++this.docID;
            if (TSDBSyntheticIdFieldsProducer.this.maxDocs <= this.docID) {
                this.docID = Integer.MAX_VALUE;
                this.latestTimestamp = -1L;
                this.latestTsId = null;
                this.term = null;
                return null;
            }
            SortedDocValues tsIdDocValues = TSDBSyntheticIdFieldsProducer.this.docValuesProducer.getSorted(TSDBSyntheticIdFieldsProducer.this.fieldInfos.fieldInfo("_tsid"));
            boolean found = tsIdDocValues.advanceExact(this.docID);
            assert (found);
            int tsIdOrd = tsIdDocValues.ordValue();
            BytesRef tsId = tsIdDocValues.lookupOrd(tsIdOrd);
            assert (tsId != null);
            SortedNumericDocValues timestampDocValues = TSDBSyntheticIdFieldsProducer.this.docValuesProducer.getSortedNumeric(TSDBSyntheticIdFieldsProducer.this.fieldInfos.fieldInfo("@timestamp"));
            found = timestampDocValues.advanceExact(this.docID);
            assert (found);
            assert (timestampDocValues.docValueCount() == 1);
            long timestamp = timestampDocValues.nextValue();
            FieldInfo tsRoutingHash = TSDBSyntheticIdFieldsProducer.this.fieldInfos.fieldInfo("_ts_routing_hash");
            assert (tsRoutingHash != null);
            SortedDocValues routingHashDocValues = TSDBSyntheticIdFieldsProducer.this.docValuesProducer.getSorted(tsRoutingHash);
            found = routingHashDocValues.advanceExact(this.docID);
            assert (found);
            BytesRef routingHashBytes = routingHashDocValues.lookupOrd(routingHashDocValues.ordValue());
            int routingHash = TimeSeriesRoutingHashFieldMapper.decode(Uid.decodeId(routingHashBytes.bytes, routingHashBytes.offset, routingHashBytes.length));
            this.term = Uid.encodeId(TsidExtractingIdFieldMapper.createId(routingHash, tsId, timestamp));
            this.latestTimestamp = timestamp;
            this.latestTsId = tsId;
            return this.term;
        }

        public TermsEnum.SeekStatus seekCeil(BytesRef id) {
            assert (id != null);
            if (this.term != null && this.term.equals((Object)id)) {
                return TermsEnum.SeekStatus.FOUND;
            }
            try {
                while (this.next() != null) {
                    if (!this.term.equals((Object)id)) continue;
                    return TermsEnum.SeekStatus.FOUND;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return TermsEnum.SeekStatus.END;
        }

        public BytesRef term() {
            return this.term;
        }

        public PostingsEnum postings(PostingsEnum reuse, int flags) {
            return new FakePostingsEnum(this.docID, this.latestTsId, this.latestTimestamp, TSDBSyntheticIdFieldsProducer.this.maxDocs);
        }

        public long ord() {
            throw TSDBSyntheticIdFieldsProducer.unsupportedException();
        }

        public void seekExact(long ord) {
            throw TSDBSyntheticIdFieldsProducer.unsupportedException();
        }

        public int docFreq() throws IOException {
            return 0;
        }

        public long totalTermFreq() throws IOException {
            return 0L;
        }

        public ImpactsEnum impacts(int flags) throws IOException {
            return null;
        }
    }
}

