/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MetadataCreateDataStreamService;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.routing.IndexRouting;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexSettingProvider;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexSortConfig;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.TimestampBounds;
import org.elasticsearch.index.mapper.IdFieldMapper;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ProvidedIdFieldMapper;
import org.elasticsearch.index.mapper.RoutingFieldMapper;
import org.elasticsearch.index.mapper.RoutingFields;
import org.elasticsearch.index.mapper.RoutingPathFields;
import org.elasticsearch.index.mapper.SourceFieldMapper;
import org.elasticsearch.index.mapper.TimeSeriesIdFieldMapper;
import org.elasticsearch.index.mapper.TimeSeriesRoutingHashFieldMapper;
import org.elasticsearch.index.mapper.TsidExtractingIdFieldMapper;

public enum IndexMode {
    STANDARD("standard"){

        @Override
        void validateWithOtherSettings(Map<Setting<?>, Object> settings) {
            IndexMode.validateRoutingPathSettings(settings);
        }

        @Override
        public void validateMapping(MappingLookup lookup) {
        }

        @Override
        public void validateAlias(@Nullable String indexRouting, @Nullable String searchRouting) {
        }

        @Override
        public void validateTimestampFieldMapping(boolean isDataStream, MappingLookup mappingLookup) throws IOException {
            if (isDataStream) {
                MetadataCreateDataStreamService.validateTimestampFieldMapping(mappingLookup);
            }
        }

        @Override
        public CompressedXContent getDefaultMapping(IndexSettings indexSettings) {
            return null;
        }

        @Override
        public TimestampBounds getTimestampBound(IndexMetadata indexMetadata) {
            return null;
        }

        @Override
        public MetadataFieldMapper timeSeriesIdFieldMapper(MappingParserContext c) {
            return null;
        }

        @Override
        public MetadataFieldMapper timeSeriesRoutingHashFieldMapper() {
            return null;
        }

        @Override
        public IdFieldMapper idFieldMapperWithoutFieldData() {
            return ProvidedIdFieldMapper.NO_FIELD_DATA;
        }

        @Override
        public IdFieldMapper buildIdFieldMapper(BooleanSupplier fieldDataEnabled) {
            return new ProvidedIdFieldMapper(fieldDataEnabled);
        }

        @Override
        public RoutingFields buildRoutingFields(IndexSettings settings) {
            return RoutingFields.Noop.INSTANCE;
        }

        @Override
        public boolean shouldValidateTimestamp() {
            return false;
        }

        @Override
        public void validateSourceFieldMapper(SourceFieldMapper sourceFieldMapper) {
        }

        @Override
        public SourceFieldMapper.Mode defaultSourceMode() {
            return SourceFieldMapper.Mode.STORED;
        }

        @Override
        public boolean useDefaultPostingsFormat() {
            return true;
        }
    }
    ,
    TIME_SERIES("time_series"){

        @Override
        void validateWithOtherSettings(Map<Setting<?>, Object> settings) {
            if (settings.get(IndexMetadata.INDEX_ROUTING_PARTITION_SIZE_SETTING) != Integer.valueOf(1)) {
                throw new IllegalArgumentException(2.error(IndexMetadata.INDEX_ROUTING_PARTITION_SIZE_SETTING));
            }
            Settings settingsWithIndexMode = Settings.builder().put(IndexSettings.MODE.getKey(), this.getName()).build();
            for (Setting<?> unsupported : TIME_SERIES_UNSUPPORTED) {
                if (Objects.equals(unsupported.getDefault(settingsWithIndexMode), settings.get(unsupported))) continue;
                throw new IllegalArgumentException(2.error(unsupported));
            }
            Setting<List<String>> routingPath = IndexMetadata.INDEX_ROUTING_PATH;
            if (2.isEmpty(settings, routingPath) && 2.isEmpty(settings, IndexMetadata.INDEX_DIMENSIONS)) {
                throw new IllegalArgumentException(2.tsdbMode() + " requires a non-empty [" + routingPath.getKey() + "]");
            }
        }

        private static boolean isEmpty(Map<Setting<?>, Object> settings, Setting<List<String>> setting) {
            return Objects.equals(setting.getDefault(Settings.EMPTY), settings.get(setting));
        }

        private static String error(Setting<?> unsupported) {
            return 2.tsdbMode() + " is incompatible with [" + unsupported.getKey() + "]";
        }

        @Override
        public void validateMapping(MappingLookup lookup) {
            if (((RoutingFieldMapper)lookup.getMapper("_routing")).required()) {
                throw new IllegalArgumentException(2.routingRequiredBad());
            }
        }

        @Override
        public void validateAlias(@Nullable String indexRouting, @Nullable String searchRouting) {
            if (indexRouting != null || searchRouting != null) {
                throw new IllegalArgumentException(2.routingRequiredBad());
            }
        }

        @Override
        public void validateTimestampFieldMapping(boolean isDataStream, MappingLookup mappingLookup) throws IOException {
            MetadataCreateDataStreamService.validateTimestampFieldMapping(mappingLookup);
        }

        @Override
        public CompressedXContent getDefaultMapping(IndexSettings indexSettings) {
            return DEFAULT_MAPPING_TIMESTAMP;
        }

        @Override
        public TimestampBounds getTimestampBound(IndexMetadata indexMetadata) {
            return new TimestampBounds(indexMetadata.getTimeSeriesStart(), indexMetadata.getTimeSeriesEnd());
        }

        private static String routingRequiredBad() {
            return "routing is forbidden on CRUD operations that target indices in " + 2.tsdbMode();
        }

        @Override
        public MetadataFieldMapper timeSeriesIdFieldMapper(MappingParserContext c) {
            return TimeSeriesIdFieldMapper.getInstance(c);
        }

        @Override
        public MetadataFieldMapper timeSeriesRoutingHashFieldMapper() {
            return TimeSeriesRoutingHashFieldMapper.INSTANCE;
        }

        @Override
        public IdFieldMapper idFieldMapperWithoutFieldData() {
            return TsidExtractingIdFieldMapper.INSTANCE;
        }

        @Override
        public IdFieldMapper buildIdFieldMapper(BooleanSupplier fieldDataEnabled) {
            return TsidExtractingIdFieldMapper.INSTANCE;
        }

        @Override
        public RoutingFields buildRoutingFields(IndexSettings settings) {
            IndexRouting indexRouting = settings.getIndexRouting();
            if (indexRouting instanceof IndexRouting.ExtractFromSource.ForRoutingPath) {
                IndexRouting.ExtractFromSource.ForRoutingPath forRoutingPath = (IndexRouting.ExtractFromSource.ForRoutingPath)indexRouting;
                return new RoutingPathFields(forRoutingPath.builder());
            }
            if (indexRouting instanceof IndexRouting.ExtractFromSource.ForIndexDimensions) {
                return RoutingFields.Noop.INSTANCE;
            }
            throw new IllegalStateException("Index routing strategy not supported for index_mode=time_series: " + String.valueOf(indexRouting));
        }

        @Override
        public boolean shouldValidateTimestamp() {
            return true;
        }

        @Override
        public void validateSourceFieldMapper(SourceFieldMapper sourceFieldMapper) {
            if (!sourceFieldMapper.enabled()) {
                throw new IllegalArgumentException("_source can not be disabled in index using [" + String.valueOf((Object)TIME_SERIES) + "] index mode");
            }
        }

        @Override
        public SourceFieldMapper.Mode defaultSourceMode() {
            return SourceFieldMapper.Mode.SYNTHETIC;
        }
    }
    ,
    LOGSDB("logsdb"){

        @Override
        void validateWithOtherSettings(Map<Setting<?>, Object> settings) {
            Object setting = settings.get(IndexSettings.LOGSDB_ROUTE_ON_SORT_FIELDS);
            if (setting.equals(Boolean.FALSE)) {
                IndexMode.validateRoutingPathSettings(settings);
            }
        }

        @Override
        public void validateMapping(MappingLookup lookup) {
        }

        @Override
        public void validateAlias(String indexRouting, String searchRouting) {
        }

        @Override
        public void validateTimestampFieldMapping(boolean isDataStream, MappingLookup mappingLookup) throws IOException {
            if (isDataStream) {
                MetadataCreateDataStreamService.validateTimestampFieldMapping(mappingLookup);
            }
        }

        @Override
        public CompressedXContent getDefaultMapping(IndexSettings indexSettings) {
            return indexSettings != null && indexSettings.logsdbAddHostNameField() ? DEFAULT_MAPPING_TIMESTAMP_HOSTNAME : DEFAULT_MAPPING_TIMESTAMP;
        }

        @Override
        public IdFieldMapper buildIdFieldMapper(BooleanSupplier fieldDataEnabled) {
            return new ProvidedIdFieldMapper(fieldDataEnabled);
        }

        @Override
        public IdFieldMapper idFieldMapperWithoutFieldData() {
            return ProvidedIdFieldMapper.NO_FIELD_DATA;
        }

        @Override
        public TimestampBounds getTimestampBound(IndexMetadata indexMetadata) {
            return null;
        }

        @Override
        public MetadataFieldMapper timeSeriesIdFieldMapper(MappingParserContext c) {
            return null;
        }

        @Override
        public MetadataFieldMapper timeSeriesRoutingHashFieldMapper() {
            return null;
        }

        @Override
        public RoutingFields buildRoutingFields(IndexSettings settings) {
            return RoutingFields.Noop.INSTANCE;
        }

        @Override
        public boolean shouldValidateTimestamp() {
            return false;
        }

        @Override
        public void validateSourceFieldMapper(SourceFieldMapper sourceFieldMapper) {
            if (!sourceFieldMapper.enabled()) {
                throw new IllegalArgumentException("_source can not be disabled in index using [" + String.valueOf((Object)LOGSDB) + "] index mode");
            }
        }

        @Override
        public SourceFieldMapper.Mode defaultSourceMode() {
            return SourceFieldMapper.Mode.SYNTHETIC;
        }

        @Override
        public String getDefaultCodec() {
            return "best_compression";
        }
    }
    ,
    LOOKUP("lookup"){

        @Override
        void validateWithOtherSettings(Map<Setting<?>, Object> settings) {
            Integer providedNumberOfShards = (Integer)settings.get(IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING);
            if (providedNumberOfShards != null && providedNumberOfShards != 1) {
                throw new IllegalArgumentException("index with [lookup] mode must have [index.number_of_shards] set to 1 or unset; provided " + providedNumberOfShards);
            }
        }

        @Override
        public void validateMapping(MappingLookup lookup) {
        }

        @Override
        public void validateAlias(@Nullable String indexRouting, @Nullable String searchRouting) {
        }

        @Override
        public void validateTimestampFieldMapping(boolean isDataStream, MappingLookup mappingLookup) {
        }

        @Override
        public CompressedXContent getDefaultMapping(IndexSettings indexSettings) {
            return null;
        }

        @Override
        public TimestampBounds getTimestampBound(IndexMetadata indexMetadata) {
            return null;
        }

        @Override
        public MetadataFieldMapper timeSeriesIdFieldMapper(MappingParserContext c) {
            return null;
        }

        @Override
        public MetadataFieldMapper timeSeriesRoutingHashFieldMapper() {
            return null;
        }

        @Override
        public IdFieldMapper idFieldMapperWithoutFieldData() {
            return ProvidedIdFieldMapper.NO_FIELD_DATA;
        }

        @Override
        public IdFieldMapper buildIdFieldMapper(BooleanSupplier fieldDataEnabled) {
            return new ProvidedIdFieldMapper(fieldDataEnabled);
        }

        @Override
        public RoutingFields buildRoutingFields(IndexSettings settings) {
            return RoutingFields.Noop.INSTANCE;
        }

        @Override
        public boolean shouldValidateTimestamp() {
            return false;
        }

        @Override
        public void validateSourceFieldMapper(SourceFieldMapper sourceFieldMapper) {
        }

        @Override
        public SourceFieldMapper.Mode defaultSourceMode() {
            return SourceFieldMapper.Mode.STORED;
        }
    };

    static final String HOST_NAME = "host.name";
    private static final CompressedXContent DEFAULT_MAPPING_TIMESTAMP;
    private static final CompressedXContent DEFAULT_MAPPING_TIMESTAMP_HOSTNAME;
    private static final List<Setting<?>> TIME_SERIES_UNSUPPORTED;
    static final List<Setting<?>> VALIDATE_WITH_SETTINGS;
    private final String name;

    private static void validateRoutingPathSettings(Map<Setting<?>, Object> settings) {
        IndexMode.settingRequiresTimeSeries(settings, IndexMetadata.INDEX_ROUTING_PATH);
    }

    private static void settingRequiresTimeSeries(Map<Setting<?>, Object> settings, Setting<?> setting) {
        if (!Objects.equals(setting.getDefault(Settings.EMPTY), settings.get(setting))) {
            throw new IllegalArgumentException("[" + setting.getKey() + "] requires " + IndexMode.tsdbMode());
        }
    }

    protected static String tsdbMode() {
        return "[" + IndexSettings.MODE.getKey() + "=time_series]";
    }

    private static CompressedXContent createDefaultMapping(boolean includeHostName) throws IOException {
        return new CompressedXContent((builder, params) -> {
            builder.startObject("_doc").startObject("_data_stream_timestamp").field("enabled", true).endObject().startObject("properties").startObject("@timestamp").field("type", "date").endObject();
            if (includeHostName) {
                builder.startObject(HOST_NAME).field("type", "keyword").field("ignore_above", 1024).endObject();
            }
            return builder.endObject().endObject();
        });
    }

    private IndexMode(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    abstract void validateWithOtherSettings(Map<Setting<?>, Object> var1);

    public abstract void validateMapping(MappingLookup var1);

    public abstract void validateAlias(@Nullable String var1, @Nullable String var2);

    public abstract void validateTimestampFieldMapping(boolean var1, MappingLookup var2) throws IOException;

    @Nullable
    public abstract CompressedXContent getDefaultMapping(IndexSettings var1);

    public abstract IdFieldMapper buildIdFieldMapper(BooleanSupplier var1);

    public abstract IdFieldMapper idFieldMapperWithoutFieldData();

    @Nullable
    public abstract TimestampBounds getTimestampBound(IndexMetadata var1);

    public abstract MetadataFieldMapper timeSeriesIdFieldMapper(MappingParserContext var1);

    public abstract MetadataFieldMapper timeSeriesRoutingHashFieldMapper();

    public abstract RoutingFields buildRoutingFields(IndexSettings var1);

    public abstract boolean shouldValidateTimestamp();

    public abstract void validateSourceFieldMapper(SourceFieldMapper var1);

    public abstract SourceFieldMapper.Mode defaultSourceMode();

    public String getDefaultCodec() {
        return "default";
    }

    public boolean useDefaultPostingsFormat() {
        return false;
    }

    public static IndexMode fromString(String value) {
        return switch (value) {
            case "standard" -> STANDARD;
            case "time_series" -> TIME_SERIES;
            case "logsdb" -> LOGSDB;
            case "lookup" -> LOOKUP;
            default -> throw new IllegalArgumentException("[" + value + "] is an invalid index mode, valid modes are: [" + Arrays.stream(IndexMode.values()).map(IndexMode::toString).collect(Collectors.joining(",")) + "]");
        };
    }

    public static IndexMode readFrom(StreamInput in) throws IOException {
        byte mode = in.readByte();
        return switch (mode) {
            case 0 -> STANDARD;
            case 1 -> TIME_SERIES;
            case 2 -> LOGSDB;
            case 3 -> LOOKUP;
            default -> throw new IllegalStateException("unexpected index mode [" + mode + "]");
        };
    }

    public static void writeTo(IndexMode indexMode, StreamOutput out) throws IOException {
        int code = switch (indexMode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> 0;
            case 1 -> 1;
            case 2 -> 2;
            case 3 -> out.getTransportVersion().onOrAfter(TransportVersions.V_8_17_0) ? 3 : 0;
        };
        out.writeByte((byte)code);
    }

    public String toString() {
        return this.getName();
    }

    static {
        try {
            DEFAULT_MAPPING_TIMESTAMP = IndexMode.createDefaultMapping(false);
            DEFAULT_MAPPING_TIMESTAMP_HOSTNAME = IndexMode.createDefaultMapping(true);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        TIME_SERIES_UNSUPPORTED = List.of(IndexSortConfig.INDEX_SORT_FIELD_SETTING, IndexSortConfig.INDEX_SORT_ORDER_SETTING, IndexSortConfig.INDEX_SORT_MODE_SETTING, IndexSortConfig.INDEX_SORT_MISSING_SETTING);
        VALIDATE_WITH_SETTINGS = List.copyOf(Stream.concat(Stream.of(IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING, IndexMetadata.INDEX_ROUTING_PARTITION_SIZE_SETTING, IndexMetadata.INDEX_ROUTING_PATH, IndexMetadata.INDEX_DIMENSIONS, IndexSettings.LOGSDB_ROUTE_ON_SORT_FIELDS, IndexSettings.TIME_SERIES_START_TIME, IndexSettings.TIME_SERIES_END_TIME), TIME_SERIES_UNSUPPORTED.stream()).collect(Collectors.toSet()));
    }

    public static final class IndexModeSettingsProvider
    implements IndexSettingProvider {
        @Override
        public void provideAdditionalSettings(String indexName, String dataStreamName, IndexMode templateIndexMode, ProjectMetadata projectMetadata, Instant resolvedAt, Settings indexTemplateAndCreateRequestSettings, List<CompressedXContent> combinedTemplateMappings, IndexVersion indexVersion, Settings.Builder additionalSettings) {
            String modeName;
            IndexMode indexMode = templateIndexMode;
            if (indexMode == null && (modeName = indexTemplateAndCreateRequestSettings.get(IndexSettings.MODE.getKey())) != null) {
                indexMode = IndexMode.valueOf(modeName.toUpperCase(Locale.ROOT));
            }
            if (indexMode == LOOKUP) {
                additionalSettings.put("index.number_of_shards", 1);
            }
        }
    }
}

